/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.RandomStringUtils;

public class ContentGenerator {
    private long keySize;
    private int bufferSize;
    private final byte[] buffer;

    ContentGenerator(long keySize, int bufferSize) {
        this.keySize = keySize;
        this.bufferSize = bufferSize;
        this.buffer = RandomStringUtils.randomAscii((int)bufferSize).getBytes(StandardCharsets.UTF_8);
    }

    public void write(OutputStream outputStream) throws IOException {
        for (long nrRemaining = this.keySize; nrRemaining > 0L; nrRemaining -= (long)this.bufferSize) {
            int curSize = (int)Math.min((long)this.bufferSize, nrRemaining);
            outputStream.write(this.buffer, 0, curSize);
        }
    }
}

