/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="dcg", aliases={"datanode-chunk-generator"}, description={"Create as many chunks as possible with pure XCeiverClient."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class DatanodeChunkGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeChunkGenerator.class);
    @CommandLine.Option(names={"-a", "--async"}, description={"Use async operation."}, defaultValue="false")
    private boolean async;
    @CommandLine.Option(names={"-s", "--size"}, description={"Size of the generated chunks (in bytes)"}, defaultValue="1024")
    private int chunkSize;
    @CommandLine.Option(names={"-l", "--pipeline"}, description={"Pipeline to use. By default the first RATIS/THREE pipeline will be used."}, defaultValue="")
    private String pipelineId;
    private XceiverClientSpi xceiverClientSpi;
    private Timer timer;
    private ByteString dataToWrite;
    private ContainerProtos.ChecksumData checksumProtobuf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        this.init();
        OzoneConfiguration ozoneConf = this.createOzoneConfiguration();
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)ozoneConf)) {
            throw new IllegalArgumentException("Datanode chunk generator is not supported in secure environment");
        }
        try (StorageContainerLocationProtocol scmLocationClient = this.createStorageContainerLocationClient(ozoneConf);){
            Pipeline pipeline;
            List pipelines = scmLocationClient.listPipelines();
            if (this.pipelineId != null && this.pipelineId.length() > 0) {
                pipeline = pipelines.stream().filter(p -> p.getId().toString().equals(this.pipelineId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Pipeline ID is defined, but there is no such pipeline: " + this.pipelineId));
            } else {
                pipeline = pipelines.stream().filter(p -> p.getFactor() == HddsProtos.ReplicationFactor.THREE).findFirst().orElseThrow(() -> new IllegalArgumentException("Pipeline ID is NOT defined, and no pipeline has been found with factor=THREE"));
                LOG.info("Using pipeline {}", (Object)pipeline.getId());
            }
            try (XceiverClientManager xceiverClientManager = new XceiverClientManager((ConfigurationSource)ozoneConf);){
                this.xceiverClientSpi = xceiverClientManager.acquireClient(pipeline);
                this.timer = this.getMetrics().timer("chunk-write");
                byte[] data = RandomStringUtils.randomAscii((int)this.chunkSize).getBytes(StandardCharsets.UTF_8);
                this.dataToWrite = ByteString.copyFrom((byte[])data);
                Checksum checksum = new Checksum(ContainerProtos.ChecksumType.CRC32, this.chunkSize);
                this.checksumProtobuf = checksum.computeChecksum(data).getProtoBufMessage();
                this.runTests(this::writeChunk);
            }
        }
        finally {
            if (this.xceiverClientSpi != null) {
                this.xceiverClientSpi.close();
            }
        }
        return null;
    }

    private void writeChunk(long stepNo) throws Exception {
        ContainerProtos.DatanodeBlockID blockId = ContainerProtos.DatanodeBlockID.newBuilder().setContainerID(1L).setLocalID(stepNo % 20L).setBlockCommitSequenceId(stepNo).build();
        ContainerProtos.ChunkInfo chunkInfo = ContainerProtos.ChunkInfo.newBuilder().setChunkName(this.getPrefix() + "_testdata_chunk_" + stepNo).setOffset(stepNo / 20L * (long)this.chunkSize).setLen((long)this.chunkSize).setChecksumData(this.checksumProtobuf).build();
        ContainerProtos.WriteChunkRequestProto.Builder writeChunkRequest = ContainerProtos.WriteChunkRequestProto.newBuilder().setBlockID(blockId).setChunkData(chunkInfo).setData(this.dataToWrite);
        String id = this.xceiverClientSpi.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.WriteChunk).setContainerID(blockId.getContainerID()).setDatanodeUuid(id).setWriteChunk(writeChunkRequest);
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        this.timer.time(() -> {
            if (this.async) {
                XceiverClientReply xceiverClientReply = this.xceiverClientSpi.sendCommandAsync(request);
                this.xceiverClientSpi.watchForCommit(xceiverClientReply.getLogIndex());
            } else {
                this.xceiverClientSpi.sendCommand(request);
            }
            return null;
        });
    }
}

