/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import java.io.IOException;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.freon.ChunkManagerDiskWrite;
import org.apache.hadoop.ozone.freon.DatanodeBlockPutter;
import org.apache.hadoop.ozone.freon.DatanodeChunkGenerator;
import org.apache.hadoop.ozone.freon.FollowerAppendLogEntryGenerator;
import org.apache.hadoop.ozone.freon.FreonHttpServer;
import org.apache.hadoop.ozone.freon.HadoopDirTreeGenerator;
import org.apache.hadoop.ozone.freon.HadoopFsGenerator;
import org.apache.hadoop.ozone.freon.HadoopFsValidator;
import org.apache.hadoop.ozone.freon.HadoopNestedDirGenerator;
import org.apache.hadoop.ozone.freon.LeaderAppendLogEntryGenerator;
import org.apache.hadoop.ozone.freon.OmBucketGenerator;
import org.apache.hadoop.ozone.freon.OmKeyGenerator;
import org.apache.hadoop.ozone.freon.OzoneClientKeyGenerator;
import org.apache.hadoop.ozone.freon.OzoneClientKeyValidator;
import org.apache.hadoop.ozone.freon.RandomKeyGenerator;
import org.apache.hadoop.ozone.freon.S3KeyGenerator;
import org.apache.hadoop.ozone.freon.SameKeyReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ozone freon", description={"Load generator and tester tool for ozone"}, subcommands={RandomKeyGenerator.class, OzoneClientKeyGenerator.class, OzoneClientKeyValidator.class, OmKeyGenerator.class, OmBucketGenerator.class, HadoopFsGenerator.class, HadoopNestedDirGenerator.class, HadoopDirTreeGenerator.class, HadoopFsValidator.class, SameKeyReader.class, S3KeyGenerator.class, DatanodeChunkGenerator.class, DatanodeBlockPutter.class, FollowerAppendLogEntryGenerator.class, ChunkManagerDiskWrite.class, LeaderAppendLogEntryGenerator.class}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class Freon
extends GenericCli {
    public static final Logger LOG = LoggerFactory.getLogger(Freon.class);
    @CommandLine.Option(names={"--server"}, description={"Enable internal http server to provide metric and profile endpoint"})
    private boolean httpServer = false;
    private final boolean interactive = System.console() != null;
    private FreonHttpServer freonHttpServer;
    private OzoneConfiguration conf;

    public void execute(String[] argv) {
        this.conf = this.createOzoneConfiguration();
        HddsServerUtil.initializeMetrics((OzoneConfiguration)this.conf, (String)"ozone-freon");
        TracingUtil.initTracing((String)"freon", (ConfigurationSource)this.conf);
        super.execute(argv);
    }

    public void stopHttpServer() {
        if (this.freonHttpServer != null) {
            try {
                this.freonHttpServer.stop();
            }
            catch (Exception e) {
                LOG.error("Freon http server can't be stopped", (Throwable)e);
            }
        }
    }

    public void startHttpServer() {
        if (this.httpServer) {
            try {
                this.freonHttpServer = new FreonHttpServer((MutableConfigurationSource)this.conf);
                this.freonHttpServer.start();
            }
            catch (IOException e) {
                LOG.error("Freon http server can't be started", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        new Freon().run(args);
    }

    public boolean isInteractive() {
        return this.interactive;
    }
}

