/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.freon.ContentGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="dfsg", aliases={"dfs-file-generator"}, description={"Create random files to the any dfs compatible file system."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class HadoopFsGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopFsGenerator.class);
    @CommandLine.Option(names={"--path"}, description={"Hadoop FS file system path"}, defaultValue="o3fs://bucket1.vol1")
    private String rootPath;
    @CommandLine.Option(names={"-s", "--size"}, description={"Size of the generated files (in bytes)"}, defaultValue="10240")
    private int fileSize;
    @CommandLine.Option(names={"--buffer"}, description={"Size of buffer used to generated the key content."}, defaultValue="4096")
    private int bufferSize;
    private ContentGenerator contentGenerator;
    private Timer timer;
    private FileSystem fileSystem;

    @Override
    public Void call() throws Exception {
        this.init();
        OzoneConfiguration configuration = this.createOzoneConfiguration();
        this.fileSystem = FileSystem.get((URI)URI.create(this.rootPath), (Configuration)configuration);
        this.contentGenerator = new ContentGenerator(this.fileSize, this.bufferSize);
        this.timer = this.getMetrics().timer("file-create");
        this.runTests(this::createFile);
        return null;
    }

    private void createFile(long counter) throws Exception {
        Path file = new Path(this.rootPath + "/" + this.generateObjectName(counter));
        this.fileSystem.mkdirs(file.getParent());
        this.timer.time(() -> {
            try (FSDataOutputStream output = this.fileSystem.create(file);){
                this.contentGenerator.write((OutputStream)output);
            }
            return null;
        });
    }
}

