/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import java.net.URI;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ddsg", aliases={"dfs-directory-generator"}, description={"Create nested directories to the any dfs compatible file system."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class HadoopNestedDirGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopNestedDirGenerator.class);
    @CommandLine.Option(names={"-r", "--rpath"}, description={"Hadoop FS directory system path"}, defaultValue="o3fs://bucket2.vol2")
    private String rootPath;
    @CommandLine.Option(names={"-d", "--depth"}, description={"Number of directories to be generated recursively"}, defaultValue="5")
    private int depth;
    @CommandLine.Option(names={"-s", "--span"}, description={"Number of child directories to be created in leaf directory."}, defaultValue="10")
    private int span;
    @CommandLine.Option(names={"-l", "--nameLen"}, description={"Length of the random name of directory you want to create."}, defaultValue="10")
    private int length;
    private FileSystem fileSystem;

    @Override
    public Void call() throws Exception {
        this.init();
        OzoneConfiguration configuration = this.createOzoneConfiguration();
        this.fileSystem = FileSystem.get((URI)URI.create(this.rootPath), (Configuration)configuration);
        this.runTests(this::createDir);
        return null;
    }

    private void createDir(long counter) throws Exception {
        String dirString = RandomStringUtils.randomAlphanumeric((int)this.length);
        for (int i = 1; i <= this.depth; ++i) {
            dirString = dirString.concat("/").concat(RandomStringUtils.randomAlphanumeric((int)this.length));
        }
        Path file = new Path(this.rootPath.concat("/").concat(dirString));
        this.fileSystem.mkdirs(file.getParent());
        String leafDir = dirString.substring(0, dirString.length() - this.length);
        String tmp = "/0";
        for (int i = 1; i <= this.span; ++i) {
            String childDir = leafDir.concat(Integer.toString(i)).concat(tmp);
            Path dir = new Path(this.rootPath.concat("/").concat(childDir));
            this.fileSystem.mkdirs(dir.getParent());
        }
    }
}

