/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ockv", aliases={"ozone-client-key-validator"}, description={"Validate keys with the help of the ozone clients."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class OzoneClientKeyValidator
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneClientKeyValidator.class);
    @CommandLine.Option(names={"-v", "--volume"}, description={"Name of the bucket which contains the test data. Will be created if missing."}, defaultValue="vol1")
    private String volumeName;
    @CommandLine.Option(names={"-b", "--bucket"}, description={"Name of the bucket which contains the test data."}, defaultValue="bucket1")
    private String bucketName;
    @CommandLine.Option(names={"-s", "--stream"}, description={"Whether to calculate key digest during read from stream, or separately after it is completely read."}, defaultValue="false")
    private boolean stream;
    @CommandLine.Option(names={"--om-service-id"}, description={"OM Service ID"})
    private String omServiceID = null;
    private Timer timer;
    private byte[] referenceDigest;
    private long referenceKeySize;
    private OzoneClient rpcClient;

    @Override
    public Void call() throws Exception {
        this.init();
        OzoneConfiguration ozoneConfiguration = this.createOzoneConfiguration();
        this.rpcClient = this.createOzoneClient(this.omServiceID, ozoneConfiguration);
        this.readReference();
        this.timer = this.getMetrics().timer("key-validate");
        this.runTests(this::validateKey);
        return null;
    }

    private void readReference() throws IOException {
        String name = this.generateObjectName(0L);
        if (!this.stream) {
            this.referenceKeySize = this.getKeySize(name);
            if (this.referenceKeySize > 0x7FFFFFF7L) {
                LOG.warn("Forcing 'stream' option, as key size is too large: {} bytes", (Object)this.referenceKeySize);
                this.stream = true;
            }
        }
        if (this.stream) {
            this.referenceDigest = this.calculateDigestStreaming(name);
        } else {
            byte[] data = this.readKeyToByteArray(name);
            this.referenceDigest = OzoneClientKeyValidator.getDigest(data);
        }
    }

    private long getKeySize(String keyName) throws IOException {
        return this.rpcClient.getObjectStore().getVolume(this.volumeName).getBucket(this.bucketName).getKey(keyName).getDataSize();
    }

    private void validateKey(long counter) throws Exception {
        String objectName = this.generateObjectName(counter);
        byte[] digest = this.getDigest(objectName);
        this.validateDigest(objectName, digest);
    }

    private byte[] getDigest(String objectName) throws Exception {
        byte[] digest;
        if (this.stream) {
            digest = (byte[])this.timer.time(() -> this.calculateDigestStreaming(objectName));
        } else {
            byte[] data = (byte[])this.timer.time(() -> this.readKeyToByteArray(objectName));
            digest = OzoneClientKeyValidator.getDigest(data);
        }
        return digest;
    }

    private byte[] calculateDigestStreaming(String name) throws IOException {
        return (byte[])this.readKey(name, BaseFreonGenerator::getDigest);
    }

    private byte[] readKeyToByteArray(String name) throws IOException {
        return (byte[])this.readKey(name, in -> IOUtils.toByteArray((InputStream)in, (long)this.referenceKeySize));
    }

    private <T> T readKey(String keyName, CheckedFunction<InputStream, T, IOException> reader) throws IOException {
        try (OzoneInputStream in = this.rpcClient.getObjectStore().getVolume(this.volumeName).getBucket(this.bucketName).readKey(keyName);){
            Object object = reader.apply((Object)in);
            return (T)object;
        }
    }

    private void validateDigest(String objectName, byte[] digest) {
        if (!MessageDigest.isEqual(this.referenceDigest, digest)) {
            throw new IllegalStateException("Reference (=first) message digest doesn't match with digest of " + objectName);
        }
    }
}

