/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.fsck;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.fsck.BlockIdDetails;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class ContainerMapper {
    private static Table getMetaTable(OzoneConfiguration configuration) throws IOException {
        OmMetadataManagerImpl metadataManager = new OmMetadataManagerImpl(configuration);
        return metadataManager.getKeyTable();
    }

    public static void main(String[] args) throws IOException {
        String path = args[0];
        if (path == null) {
            throw new IOException("Path cannot be null");
        }
        OzoneConfiguration configuration = new OzoneConfiguration();
        configuration.set("ozone.om.db.dirs", path);
        ContainerMapper containerMapper = new ContainerMapper();
        Map<Long, List<Map<Long, BlockIdDetails>>> dataMap = containerMapper.parseOmDB(configuration);
        ObjectMapper mapper = new ObjectMapper();
        System.out.println(mapper.writeValueAsString(dataMap));
    }

    public Map<Long, List<Map<Long, BlockIdDetails>>> parseOmDB(OzoneConfiguration configuration) throws IOException {
        String path = configuration.get("ozone.om.db.dirs");
        if (path == null || path.isEmpty()) {
            throw new IOException("ozone.om.db.dirsshould be set ");
        }
        Table keyTable = ContainerMapper.getMetaTable(configuration);
        HashMap<Long, List<Map<Long, BlockIdDetails>>> dataMap = new HashMap<Long, List<Map<Long, BlockIdDetails>>>();
        if (keyTable != null) {
            try (TableIterator keyValueTableIterator = keyTable.iterator();){
                while (keyValueTableIterator.hasNext()) {
                    Table.KeyValue keyValue = (Table.KeyValue)keyValueTableIterator.next();
                    OmKeyInfo omKeyInfo = (OmKeyInfo)keyValue.getValue();
                    byte[] value = omKeyInfo.getProtobuf().toByteArray();
                    OmKeyInfo keyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)OzoneManagerProtocolProtos.KeyInfo.parseFrom((byte[])value));
                    for (OmKeyLocationInfoGroup keyLocationInfoGroup : keyInfo.getKeyLocationVersions()) {
                        List keyLocationInfo = keyLocationInfoGroup.getLocationList();
                        for (OmKeyLocationInfo keyLocation : keyLocationInfo) {
                            BlockIdDetails blockIdDetails = new BlockIdDetails();
                            HashMap<Long, BlockIdDetails> innerMap = new HashMap<Long, BlockIdDetails>();
                            long containerID = keyLocation.getBlockID().getContainerID();
                            long blockID = keyLocation.getBlockID().getLocalID();
                            blockIdDetails.setBucketName(keyInfo.getBucketName());
                            blockIdDetails.setBlockVol(keyInfo.getVolumeName());
                            blockIdDetails.setKeyName(keyInfo.getKeyName());
                            List<HashMap<Long, BlockIdDetails>> innerList = new ArrayList<HashMap<Long, BlockIdDetails>>();
                            innerMap.put(blockID, blockIdDetails);
                            if (dataMap.containsKey(containerID)) {
                                innerList = (List)dataMap.get(containerID);
                            }
                            innerList.add(innerMap);
                            dataMap.put(containerID, innerList);
                        }
                    }
                }
            }
        }
        return dataMap;
    }
}

