/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genconf;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import picocli.CommandLine;

@CommandLine.Command(name="ozone genconf", description={"Tool to generate template ozone-site.xml"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public final class GenerateOzoneRequiredConfigurations
extends GenericCli {
    @CommandLine.Parameters(arity="1..1", description={"Directory path where ozone-site file should be generated."})
    private String path;

    public static void main(String[] args) throws Exception {
        new GenerateOzoneRequiredConfigurations().run(args);
    }

    public Void call() throws Exception {
        GenerateOzoneRequiredConfigurations.generateConfigurations(this.path);
        return null;
    }

    public static void generateConfigurations(String path) throws CommandLine.PicocliException, JAXBException, IOException {
        if (!GenerateOzoneRequiredConfigurations.isValidPath(path)) {
            throw new CommandLine.PicocliException("Invalid directory path.");
        }
        if (!GenerateOzoneRequiredConfigurations.canWrite(path)) {
            throw new CommandLine.PicocliException("Insufficient permission.");
        }
        OzoneConfiguration oc = new OzoneConfiguration();
        ClassLoader cL = Thread.currentThread().getContextClassLoader();
        if (cL == null) {
            cL = OzoneConfiguration.class.getClassLoader();
        }
        URL url = cL.getResource("ozone-default.xml");
        List allProperties = oc.readPropertyFromXml(url);
        ArrayList<OzoneConfiguration.Property> requiredProperties = new ArrayList<OzoneConfiguration.Property>();
        for (OzoneConfiguration.Property p : allProperties) {
            if (p.getTag() == null || !p.getTag().contains("REQUIRED")) continue;
            if (p.getName().equalsIgnoreCase("ozone.metadata.dirs")) {
                p.setValue(System.getProperty("java.io.tmpdir"));
            } else if (p.getName().equalsIgnoreCase("ozone.om.address") || p.getName().equalsIgnoreCase("ozone.scm.names") || p.getName().equalsIgnoreCase("ozone.scm.client.address")) {
                p.setValue("localhost");
            }
            requiredProperties.add(p);
        }
        OzoneConfiguration.XMLConfiguration requiredConfig = new OzoneConfiguration.XMLConfiguration();
        requiredConfig.setProperties(requiredProperties);
        File output = new File(path, "ozone-site.xml");
        if (output.createNewFile()) {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{OzoneConfiguration.XMLConfiguration.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)requiredConfig, output);
            System.out.println("ozone-site.xml has been generated at " + path);
        } else {
            System.out.printf("ozone-site.xml already exists at %s and will not be overwritten%n", path);
        }
    }

    public static boolean isValidPath(String path) {
        try {
            return Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0]);
        }
        catch (NullPointerException | InvalidPathException ex) {
            return Boolean.FALSE;
        }
    }

    public static boolean canWrite(String path) {
        File file = new File(path);
        return file.canWrite();
    }
}

