/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genesis;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.impl.ChunkLayOutVersion;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.DispatcherContext;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.ImmutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.impl.FilePerBlockStrategy;
import org.apache.hadoop.ozone.container.keyvalue.impl.FilePerChunkStrategy;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.ChunkManager;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@Warmup(time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(time=1, timeUnit=TimeUnit.SECONDS)
public class BenchmarkChunkManager {
    private static final String DEFAULT_TEST_DATA_DIR = "target" + File.separator + "test" + File.separator + "data";
    private static final AtomicLong CONTAINER_COUNTER = new AtomicLong();
    private static final DispatcherContext WRITE_STAGE = new DispatcherContext.Builder().setStage(DispatcherContext.WriteChunkStage.WRITE_DATA).build();
    private static final DispatcherContext COMMIT_STAGE = new DispatcherContext.Builder().setStage(DispatcherContext.WriteChunkStage.COMMIT_DATA).build();
    private static final long CONTAINER_SIZE = 0x40000000L;
    private static final long BLOCK_SIZE = 0x10000000L;
    private static final String SCM_ID = UUID.randomUUID().toString();
    private static final String DATANODE_ID = UUID.randomUUID().toString();

    @Benchmark
    public void writeMultipleFiles(BenchmarkState state, Blackhole sink) throws StorageContainerException {
        FilePerChunkStrategy chunkManager = new FilePerChunkStrategy(true, null);
        this.benchmark((ChunkManager)chunkManager, ChunkLayOutVersion.FILE_PER_CHUNK, state, sink);
    }

    @Benchmark
    public void writeSingleFile(BenchmarkState state, Blackhole sink) throws StorageContainerException {
        FilePerBlockStrategy chunkManager = new FilePerBlockStrategy(true);
        this.benchmark((ChunkManager)chunkManager, ChunkLayOutVersion.FILE_PER_BLOCK, state, sink);
    }

    private void benchmark(ChunkManager subject, ChunkLayOutVersion layout, BenchmarkState state, Blackhole sink) throws StorageContainerException {
        long containerID = CONTAINER_COUNTER.getAndIncrement();
        KeyValueContainerData containerData = new KeyValueContainerData(containerID, layout, 0x40000000L, UUID.randomUUID().toString(), DATANODE_ID);
        KeyValueContainer container = new KeyValueContainer(containerData, (ConfigurationSource)state.config);
        container.create(state.volumeSet, (volumes, any) -> (HddsVolume)volumes.get(0), SCM_ID);
        long blockCount = 4L;
        long chunkCount = 0x10000000L / (long)state.chunkSize;
        for (long b = 0L; b < 4L; ++b) {
            BlockID blockID = new BlockID(containerID, b);
            for (long c = 0L; c < chunkCount; ++c) {
                String chunkName = String.format("block.%d.chunk.%d", b, c);
                long offset = c * (long)state.chunkSize;
                ChunkInfo chunkInfo = new ChunkInfo(chunkName, offset, (long)state.chunkSize);
                ChunkBuffer data = state.buffer.duplicate(0, state.chunkSize);
                subject.writeChunk((Container)container, blockID, chunkInfo, data, WRITE_STAGE);
                subject.writeChunk((Container)container, blockID, chunkInfo, data, COMMIT_STAGE);
                sink.consume((Object)chunkInfo);
            }
        }
    }

    @State(value=Scope.Benchmark)
    public static class BenchmarkState {
        @Param(value={"1048576", "4194304", "16777216", "67108864"})
        private int chunkSize;
        private File dir;
        private ChunkBuffer buffer;
        private VolumeSet volumeSet;
        private OzoneConfiguration config;

        private static File getTestDir() throws IOException {
            File dir = new File(DEFAULT_TEST_DATA_DIR).getAbsoluteFile();
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            return dir;
        }

        @Setup(value=Level.Iteration)
        public void setup() throws IOException {
            this.dir = BenchmarkState.getTestDir();
            this.config = new OzoneConfiguration();
            HddsVolume volume = new HddsVolume.Builder(this.dir.getAbsolutePath()).conf((ConfigurationSource)this.config).datanodeUuid(DATANODE_ID).build();
            this.volumeSet = new ImmutableVolumeSet(new HddsVolume[]{volume});
            byte[] arr = RandomStringUtils.randomAlphanumeric((int)this.chunkSize).getBytes(StandardCharsets.UTF_8);
            this.buffer = ChunkBuffer.wrap((ByteBuffer)ByteBuffer.wrap(arr));
        }

        @TearDown(value=Level.Iteration)
        public void cleanup() {
            FileUtils.deleteQuietly((File)this.dir);
        }
    }
}

