/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.genesis;

import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.profile.StackProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import picocli.CommandLine;

@CommandLine.Command(name="ozone genesis", description={"Tool for running ozone benchmarks"}, mixinStandardHelpOptions=true)
public final class Genesis {
    @CommandLine.Option(names={"-b", "-benchmark", "--benchmark"}, split=",", description={"Option used for specifying benchmarks to run.\nEx. ozone genesis -benchmark BenchMarkContainerStateMap,BenchMarkOMKeyAllocation.\nPossible benchmarks which can be used are {BenchMarkContainerStateMap, BenchMarkOMKeyAllocation, BenchMarkOzoneManager, BenchMarkOMClient, BenchMarkSCM, BenchMarkMetadataStoreReads, BenchMarkMetadataStoreWrites, BenchMarkDatanodeDispatcher, BenchMarkRocksDbStore}"})
    private static String[] benchmarks;
    @CommandLine.Option(names={"-t"}, defaultValue="4", description={"Number of threads to use for the benchmark.\nThis option can be overridden by threads mentioned in benchmark."})
    private static int numThreads;
    @CommandLine.Option(names={"--seconds"}, description={"Number of seconds to run each benchmark method.\nBy default no limit is set."})
    private static int seconds;

    private Genesis() {
    }

    public static void main(String[] args) throws RunnerException {
        CommandLine commandLine = new CommandLine((Object)new Genesis());
        commandLine.parse(args);
        if (commandLine.isUsageHelpRequested()) {
            commandLine.usage(System.out);
            return;
        }
        OptionsBuilder optionsBuilder = new OptionsBuilder();
        if (benchmarks != null) {
            for (String benchmark : benchmarks) {
                optionsBuilder.include(benchmark);
            }
        }
        optionsBuilder.warmupIterations(2).measurementIterations(20).addProfiler(StackProfiler.class).addProfiler(GCProfiler.class).shouldDoGC(true).forks(1).threads(numThreads);
        if (seconds > 0) {
            optionsBuilder.measurementTime(TimeValue.seconds((long)seconds));
        }
        new Runner(optionsBuilder.build()).run();
    }

    static {
        seconds = -1;
    }
}

