/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.bucket;

import java.io.IOException;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.client.BucketArgs;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketHandler;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"creates a bucket in a given volume"})
public class CreateBucketHandler
extends BucketHandler {
    @CommandLine.Option(names={"--bucketkey", "-k"}, description={"bucket encryption key name"})
    private String bekName;
    @CommandLine.Option(names={"--enforcegdpr", "-g"}, description={"if true, indicates GDPR enforced bucket, false/unspecified indicates otherwise"})
    private Boolean isGdprEnforced;

    @Override
    public void execute(OzoneClient client, OzoneAddress address) throws IOException {
        BucketArgs.Builder bb = new BucketArgs.Builder().setStorageType(StorageType.DEFAULT).setVersioning(Boolean.valueOf(false));
        if (this.isGdprEnforced != null) {
            bb.addMetadata("gdprEnabled", String.valueOf(this.isGdprEnforced));
        }
        if (this.bekName != null) {
            if (this.bekName.isEmpty()) {
                throw new IllegalArgumentException("Bucket encryption key name must be specified to enable bucket encryption!");
            }
            bb.setBucketEncryptionKey(this.bekName);
            if (this.isVerbose()) {
                this.out().printf("Bucket Encryption enabled with Key Name: %s%n", this.bekName);
            }
        }
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        vol.createBucket(bucketName, bb.build());
        if (this.isVerbose()) {
            OzoneBucket bucket = vol.getBucket(bucketName);
            this.printObjectAsJson(bucket);
        }
    }
}

