/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.keys;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.shell.ListOptions;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketHandler;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"list all keys in a given bucket"})
public class ListKeyHandler
extends BucketHandler {
    @CommandLine.Mixin
    private ListOptions listOptions;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException, OzoneClientException {
        int counter;
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = vol.getBucket(bucketName);
        Iterator keyIterator = bucket.listKeys(this.listOptions.getPrefix(), this.listOptions.getStartItem());
        int maxKeyLimit = this.listOptions.getLimit();
        for (counter = 0; maxKeyLimit > counter && keyIterator.hasNext(); ++counter) {
            OzoneKey ozoneKey = (OzoneKey)keyIterator.next();
            this.printObjectAsJson(ozoneKey);
        }
        if (keyIterator.hasNext()) {
            this.out().println("Listing first " + maxKeyLimit + " entries of the result. Use --length (-l) to override max returned keys.");
        } else if (this.isVerbose()) {
            this.out().printf("Found : %d keys for bucket %s in volume : %s ", counter, bucketName, volumeName);
        }
    }
}

