/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.keys;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.keys.KeyHandler;
import picocli.CommandLine;

@CommandLine.Command(name="put", description={"creates or overwrites an existing key"})
public class PutKeyHandler
extends KeyHandler {
    @CommandLine.Parameters(index="1", arity="1..1", description={"File to upload"})
    private String fileName;
    @CommandLine.Option(names={"-r", "--replication"}, description={"Replication factor of the new key. (use ONE or THREE) Default is specified in the cluster-wide config."})
    private ReplicationFactor replicationFactor;
    @CommandLine.Option(names={"-t", "--type"}, description={"Replication type of the new key. (use RATIS or STAND_ALONE) Default is specified in the cluster-wide config."})
    private ReplicationType replicationType;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException, OzoneClientException {
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        String keyName = address.getKeyName();
        File dataFile = new File(this.fileName);
        if (this.isVerbose()) {
            try (FileInputStream stream = new FileInputStream(dataFile);){
                String hash = DigestUtils.md5Hex((InputStream)stream);
                this.out().printf("File Hash : %s%n", hash);
            }
        }
        if (this.replicationFactor == null) {
            this.replicationFactor = ReplicationFactor.valueOf((int)this.getConf().getInt("ozone.replication", OzoneConfigKeys.OZONE_REPLICATION_DEFAULT));
        }
        if (this.replicationType == null) {
            this.replicationType = ReplicationType.valueOf((String)this.getConf().get("ozone.replication.type", OzoneConfigKeys.OZONE_REPLICATION_TYPE_DEFAULT));
        }
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = vol.getBucket(bucketName);
        HashMap<String, String> keyMetadata = new HashMap<String, String>();
        String gdprEnabled = (String)bucket.getMetadata().get("gdprEnabled");
        if (Boolean.parseBoolean(gdprEnabled)) {
            keyMetadata.put("gdprEnabled", Boolean.TRUE.toString());
        }
        int chunkSize = (int)this.getConf().getStorageSize("ozone.scm.chunk.size", "4MB", StorageUnit.BYTES);
        try (FileInputStream input = new FileInputStream(dataFile);
             OzoneOutputStream output = bucket.createKey(keyName, dataFile.length(), this.replicationType, this.replicationFactor, keyMetadata);){
            IOUtils.copyBytes((InputStream)input, (OutputStream)output, (int)chunkSize);
        }
    }
}

