/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.s3;

import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.s3.S3Handler;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="getsecret", description={"Returns s3 secret for current user"})
public class GetS3SecretHandler
extends S3Handler {
    @Override
    protected boolean isApplicable() {
        return this.securityEnabled();
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String userName = UserGroupInformation.getCurrentUser().getUserName();
        this.out().println(client.getObjectStore().getS3Secret(userName));
    }
}

