/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.token;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.shell.Handler;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.token.RenewerOption;
import org.apache.hadoop.security.token.Token;
import picocli.CommandLine;

@CommandLine.Command(name="get", description={"get a delegation token."})
public class GetTokenHandler
extends Handler {
    @CommandLine.Parameters(arity="0..1", description={"Ozone URI could start with o3:// or without prefix. URI may contain the host/serviceId  and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Mixin
    private RenewerOption renewer;

    @Override
    protected OzoneAddress getAddress() throws OzoneClientException {
        return new OzoneAddress(this.uri);
    }

    @Override
    protected boolean isApplicable() {
        return this.securityEnabled();
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException, OzoneClientException {
        Token token = client.getObjectStore().getDelegationToken(new Text(this.renewer.getValue()));
        if (Objects.isNull(token)) {
            this.err().println("Error: Get delegation token operation failed. Check OzoneManager logs for more details.");
        } else {
            this.printObjectAsJson(token.encodeToUrlString());
        }
    }
}

