/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.token;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.security.token.Token;
import picocli.CommandLine;

public class TokenOption {
    @CommandLine.Option(names={"--token", "-t"}, description={"file containing encoded token"}, defaultValue="/tmp/token.txt", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private File tokenFile;

    public boolean exists() {
        boolean exists;
        boolean bl = exists = this.tokenFile != null && this.tokenFile.exists();
        if (!exists) {
            System.err.println("Error: token operation failed as token file: " + this.tokenFile + " containing encoded token doesn't exist.");
        }
        return exists;
    }

    public Token<OzoneTokenIdentifier> decode() throws IOException {
        Token token = new Token();
        token.decodeFromUrlString(new String(Files.readAllBytes(this.tokenFile.toPath()), StandardCharsets.UTF_8));
        return token;
    }
}

