/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.volume;

import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.VolumeArgs;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.volume.VolumeHandler;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Creates a volume for the specified user"})
public class CreateVolumeHandler
extends VolumeHandler {
    @CommandLine.Option(names={"--user", "-u"}, description={"Owner of of the volume"})
    private String ownerName;
    @CommandLine.Option(names={"--quota", "-q"}, description={"Quota of the newly created volume (eg. 1G)"})
    private String quota;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        if (this.ownerName == null) {
            this.ownerName = UserGroupInformation.getCurrentUser().getUserName();
        }
        String volumeName = address.getVolumeName();
        String adminName = UserGroupInformation.getCurrentUser().getUserName();
        VolumeArgs.Builder volumeArgsBuilder = VolumeArgs.newBuilder().setAdmin(adminName).setOwner(this.ownerName);
        if (this.quota != null) {
            volumeArgsBuilder.setQuota(this.quota);
        }
        client.getObjectStore().createVolume(volumeName, volumeArgsBuilder.build());
        if (this.isVerbose()) {
            OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
            this.printObjectAsJson(vol);
        }
    }
}

