/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.volume;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.shell.Handler;
import org.apache.hadoop.ozone.shell.ListOptions;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"List the volumes of a given user"})
public class ListVolumeHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"Ozone URI could start with o3:// or without prefix. URI may contain the host/serviceId  and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."}, defaultValue="/")
    private String uri;
    @CommandLine.Mixin
    private ListOptions listOptions;
    @CommandLine.Option(names={"--user", "-u"}, description={"List accessible volumes of the user. This will be ignored if list all volumes option is specified."})
    private String userName;
    @CommandLine.Option(names={"--all", "-a"}, description={"List all volumes."})
    private boolean listAllVolumes;

    @Override
    protected OzoneAddress getAddress() throws OzoneClientException {
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureRootAddress();
        return address;
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        int counter;
        if (this.userName == null) {
            this.userName = UserGroupInformation.getCurrentUser().getUserName();
        }
        Iterator volumeIterator = this.userName != null && !this.listAllVolumes ? client.getObjectStore().listVolumesByUser(this.userName, this.listOptions.getPrefix(), this.listOptions.getStartItem()) : client.getObjectStore().listVolumes(this.listOptions.getPrefix(), this.listOptions.getStartItem());
        for (counter = 0; this.listOptions.getLimit() > counter && volumeIterator.hasNext(); ++counter) {
            this.printObjectAsJson(volumeIterator.next());
        }
        if (this.isVerbose()) {
            this.out().printf("Found : %d volumes for user : %s ", counter, this.userName);
        }
    }
}

