/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.volume;

import java.io.IOException;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.volume.VolumeHandler;
import picocli.CommandLine;

@CommandLine.Command(name="update", description={"Updates parameter of the volumes"})
public class UpdateVolumeHandler
extends VolumeHandler {
    @CommandLine.Option(names={"--user"}, description={"Owner of the volume to set"})
    private String ownerName;
    @CommandLine.Option(names={"--quota"}, description={"Quota of the volume to set(eg. 1G)"})
    private String quota;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = address.getVolumeName();
        OzoneVolume volume = client.getObjectStore().getVolume(volumeName);
        if (this.quota != null && !this.quota.isEmpty()) {
            volume.setQuota(OzoneQuota.parseQuota((String)this.quota));
        }
        if (this.ownerName != null && !this.ownerName.isEmpty()) {
            boolean result = volume.setOwner(this.ownerName);
            if (LOG.isDebugEnabled() && !result) {
                this.out().format("Volume '%s' owner is already '%s'. Unchanged.%n", volumeName, this.ownerName);
            }
        }
        OzoneVolume updatedVolume = client.getObjectStore().getVolume(volumeName);
        this.printObjectAsJson(updatedVolume);
    }
}

