/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
@InterfaceStability.Unstable
public class Resources {
    private static final Resource NONE = new Resource(){

        public int getMemory() {
            return 0;
        }

        public long getMemorySize() {
            return 0L;
        }

        public void setMemorySize(long memory) {
            throw new RuntimeException("NONE cannot be modified!");
        }

        public void setMemory(int memory) {
            throw new RuntimeException("NONE cannot be modified!");
        }

        public int getVirtualCores() {
            return 0;
        }

        public void setVirtualCores(int cores) {
            throw new RuntimeException("NONE cannot be modified!");
        }

        public int compareTo(Resource o) {
            long diff = 0L - o.getMemorySize();
            if (diff == 0L) {
                diff = 0 - o.getVirtualCores();
            }
            return Long.signum(diff);
        }
    };
    private static final Resource UNBOUNDED = new Resource(){

        public int getMemory() {
            return Integer.MAX_VALUE;
        }

        public long getMemorySize() {
            return Long.MAX_VALUE;
        }

        public void setMemory(int memory) {
            throw new RuntimeException("UNBOUNDED cannot be modified!");
        }

        public void setMemorySize(long memory) {
            throw new RuntimeException("UNBOUNDED cannot be modified!");
        }

        public int getVirtualCores() {
            return Integer.MAX_VALUE;
        }

        public void setVirtualCores(int cores) {
            throw new RuntimeException("UNBOUNDED cannot be modified!");
        }

        public int compareTo(Resource o) {
            long diff = Long.MAX_VALUE - o.getMemorySize();
            if (diff == 0L) {
                diff = Integer.MAX_VALUE - o.getVirtualCores();
            }
            return Long.signum(diff);
        }
    };

    public static Resource createResource(int memory) {
        return Resources.createResource(memory, memory > 0 ? 1 : 0);
    }

    public static Resource createResource(int memory, int cores) {
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemorySize((long)memory);
        resource.setVirtualCores(cores);
        return resource;
    }

    public static Resource createResource(long memory) {
        return Resources.createResource(memory, memory > 0L ? 1 : 0);
    }

    public static Resource createResource(long memory, int cores) {
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemorySize(memory);
        resource.setVirtualCores(cores);
        return resource;
    }

    public static Resource none() {
        return NONE;
    }

    public static boolean isNone(Resource other) {
        return NONE.equals((Object)other);
    }

    public static Resource unbounded() {
        return UNBOUNDED;
    }

    public static Resource clone(Resource res) {
        return Resources.createResource(res.getMemorySize(), res.getVirtualCores());
    }

    public static Resource addTo(Resource lhs, Resource rhs) {
        lhs.setMemorySize(lhs.getMemorySize() + rhs.getMemorySize());
        lhs.setVirtualCores(lhs.getVirtualCores() + rhs.getVirtualCores());
        return lhs;
    }

    public static Resource add(Resource lhs, Resource rhs) {
        return Resources.addTo(Resources.clone(lhs), rhs);
    }

    public static Resource subtractFrom(Resource lhs, Resource rhs) {
        lhs.setMemorySize(lhs.getMemorySize() - rhs.getMemorySize());
        lhs.setVirtualCores(lhs.getVirtualCores() - rhs.getVirtualCores());
        return lhs;
    }

    public static Resource subtract(Resource lhs, Resource rhs) {
        return Resources.subtractFrom(Resources.clone(lhs), rhs);
    }

    public static Resource negate(Resource resource) {
        return Resources.subtract(NONE, resource);
    }

    public static Resource multiplyTo(Resource lhs, double by) {
        lhs.setMemorySize((long)((double)lhs.getMemorySize() * by));
        lhs.setVirtualCores((int)((double)lhs.getVirtualCores() * by));
        return lhs;
    }

    public static Resource multiply(Resource lhs, double by) {
        return Resources.multiplyTo(Resources.clone(lhs), by);
    }

    public static Resource multiplyAndAddTo(Resource lhs, Resource rhs, double by) {
        lhs.setMemorySize(lhs.getMemorySize() + (long)((double)rhs.getMemorySize() * by));
        lhs.setVirtualCores(lhs.getVirtualCores() + (int)((double)rhs.getVirtualCores() * by));
        return lhs;
    }

    public static Resource multiplyAndNormalizeUp(ResourceCalculator calculator, Resource lhs, double by, Resource factor) {
        return calculator.multiplyAndNormalizeUp(lhs, by, factor);
    }

    public static Resource multiplyAndNormalizeDown(ResourceCalculator calculator, Resource lhs, double by, Resource factor) {
        return calculator.multiplyAndNormalizeDown(lhs, by, factor);
    }

    public static Resource multiplyAndRoundDown(Resource lhs, double by) {
        Resource out = Resources.clone(lhs);
        out.setMemorySize((long)((double)lhs.getMemorySize() * by));
        out.setVirtualCores((int)((double)lhs.getVirtualCores() * by));
        return out;
    }

    public static Resource normalize(ResourceCalculator calculator, Resource lhs, Resource min, Resource max, Resource increment) {
        return calculator.normalize(lhs, min, max, increment);
    }

    public static Resource roundUp(ResourceCalculator calculator, Resource lhs, Resource factor) {
        return calculator.roundUp(lhs, factor);
    }

    public static Resource roundDown(ResourceCalculator calculator, Resource lhs, Resource factor) {
        return calculator.roundDown(lhs, factor);
    }

    public static boolean isInvalidDivisor(ResourceCalculator resourceCalculator, Resource divisor) {
        return resourceCalculator.isInvalidDivisor(divisor);
    }

    public static float ratio(ResourceCalculator resourceCalculator, Resource lhs, Resource rhs) {
        return resourceCalculator.ratio(lhs, rhs);
    }

    public static float divide(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.divide(clusterResource, lhs, rhs);
    }

    public static Resource divideAndCeil(ResourceCalculator resourceCalculator, Resource lhs, int rhs) {
        return resourceCalculator.divideAndCeil(lhs, rhs);
    }

    public static boolean equals(Resource lhs, Resource rhs) {
        return lhs.equals((Object)rhs);
    }

    public static boolean lessThan(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) < 0;
    }

    public static boolean lessThanOrEqual(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) <= 0;
    }

    public static boolean greaterThan(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) > 0;
    }

    public static boolean greaterThanOrEqual(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) >= 0;
    }

    public static Resource min(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) <= 0 ? lhs : rhs;
    }

    public static Resource max(ResourceCalculator resourceCalculator, Resource clusterResource, Resource lhs, Resource rhs) {
        return resourceCalculator.compare(clusterResource, lhs, rhs) >= 0 ? lhs : rhs;
    }

    public static boolean fitsIn(Resource smaller, Resource bigger) {
        return smaller.getMemorySize() <= bigger.getMemorySize() && smaller.getVirtualCores() <= bigger.getVirtualCores();
    }

    public static boolean fitsIn(ResourceCalculator rc, Resource cluster, Resource smaller, Resource bigger) {
        return rc.fitsIn(cluster, smaller, bigger);
    }

    public static Resource componentwiseMin(Resource lhs, Resource rhs) {
        return Resources.createResource(Math.min(lhs.getMemorySize(), rhs.getMemorySize()), Math.min(lhs.getVirtualCores(), rhs.getVirtualCores()));
    }

    public static Resource componentwiseMax(Resource lhs, Resource rhs) {
        return Resources.createResource(Math.max(lhs.getMemorySize(), rhs.getMemorySize()), Math.max(lhs.getVirtualCores(), rhs.getVirtualCores()));
    }
}

