/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.log;

import com.google.inject.Inject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.HarFs;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class AggregatedLogsBlock
extends HtmlBlock {
    private final Configuration conf;

    @Inject
    AggregatedLogsBlock(Configuration conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void render(HtmlBlock.Block html) {
        RemoteIterator nodeFiles;
        ContainerId containerId = this.verifyAndGetContainerId(html);
        NodeId nodeId = this.verifyAndGetNodeId(html);
        String appOwner = this.verifyAndGetAppOwner(html);
        LogLimits logLimits = this.verifyAndGetLogLimits(html);
        if (containerId == null) return;
        if (nodeId == null) return;
        if (appOwner == null) return;
        if (appOwner.isEmpty()) return;
        if (logLimits == null) {
            return;
        }
        ApplicationId applicationId = containerId.getApplicationAttemptId().getApplicationId();
        String logEntity = this.$("entity.string");
        if (logEntity == null || logEntity.isEmpty()) {
            logEntity = containerId.toString();
        }
        String nmApplicationLogUrl = this.getApplicationLogURL(applicationId);
        if (!this.conf.getBoolean("yarn.log-aggregation-enable", false)) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Aggregation is not enabled. Try the nodemanager at " + nodeId})))._();
            if (nmApplicationLogUrl == null) return;
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Or see application log at " + nmApplicationLogUrl})))._();
            return;
        }
        Path remoteRootLogDir = new Path(this.conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        Path remoteAppDir = LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, applicationId, appOwner, LogAggregationUtils.getRemoteNodeLogDirSuffix(this.conf));
        try {
            Path qualifiedLogDir = FileContext.getFileContext((Configuration)this.conf).makeQualified(remoteAppDir);
            nodeFiles = FileContext.getFileContext((URI)qualifiedLogDir.toUri(), (Configuration)this.conf).listStatus(remoteAppDir);
        }
        catch (FileNotFoundException fnf) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Logs not available for " + logEntity + ". Aggregation may not be complete, Check back later or try the nodemanager at " + nodeId})))._();
            if (nmApplicationLogUrl == null) return;
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Or see application log at " + nmApplicationLogUrl})))._();
            return;
        }
        catch (Exception ex) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Error getting logs at " + nodeId})))._();
            return;
        }
        boolean foundLog = false;
        String desiredLogType = this.$("log.type");
        try {
            while (nodeFiles.hasNext()) {
                AggregatedLogFormat.LogReader reader = null;
                try {
                    FileStatus thisNodeFile = (FileStatus)nodeFiles.next();
                    if (thisNodeFile.getPath().getName().equals(applicationId + ".har")) {
                        Path p = new Path("har:///" + thisNodeFile.getPath().toUri().getRawPath());
                        nodeFiles = HarFs.get((URI)p.toUri(), (Configuration)this.conf).listStatusIterator(p);
                        continue;
                    }
                    if (!thisNodeFile.getPath().getName().contains(LogAggregationUtils.getNodeString(nodeId)) || thisNodeFile.getPath().getName().endsWith(".tmp")) continue;
                    long logUploadedTime = thisNodeFile.getModificationTime();
                    reader = new AggregatedLogFormat.LogReader(this.conf, thisNodeFile.getPath());
                    String owner = null;
                    Map<ApplicationAccessType, String> appAcls = null;
                    try {
                        owner = reader.getApplicationOwner();
                        appAcls = reader.getApplicationAcls();
                    }
                    catch (IOException e) {
                        LOG.error("Error getting logs for " + logEntity, (Throwable)e);
                        if (reader == null) continue;
                        reader.close();
                        continue;
                    }
                    ApplicationACLsManager aclsManager = new ApplicationACLsManager(this.conf);
                    aclsManager.addApplication(applicationId, appAcls);
                    String remoteUser = this.request().getRemoteUser();
                    UserGroupInformation callerUGI = null;
                    if (remoteUser != null) {
                        callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
                    }
                    if (callerUGI != null && !aclsManager.checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, owner, applicationId)) {
                        ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"User [" + remoteUser + "] is not authorized to view the logs for " + logEntity + " in log file [" + thisNodeFile.getPath().getName() + "]"})))._();
                        LOG.error("User [" + remoteUser + "] is not authorized to view the logs for " + logEntity);
                        continue;
                    }
                    AggregatedLogFormat.ContainerLogsReader logReader = reader.getContainerLogsReader(containerId);
                    if (logReader == null) continue;
                    foundLog = this.readContainerLogs(html, logReader, logLimits, desiredLogType, logUploadedTime);
                }
                catch (IOException ex) {
                    LOG.error("Error getting logs for " + logEntity, (Throwable)ex);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            if (foundLog) return;
            if (desiredLogType.isEmpty()) {
                html.h1("No logs available for container " + containerId.toString());
                return;
            }
            html.h1("Unable to locate '" + desiredLogType + "' log for container " + containerId.toString());
            return;
        }
        catch (IOException e) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Error getting logs for " + logEntity})))._();
            LOG.error("Error getting logs for " + logEntity, (Throwable)e);
        }
    }

    private boolean readContainerLogs(HtmlBlock.Block html, AggregatedLogFormat.ContainerLogsReader logReader, LogLimits logLimits, String desiredLogType, long logUpLoadTime) throws IOException {
        int bufferSize = 65536;
        char[] cbuf = new char[bufferSize];
        boolean foundLog = false;
        String logType = logReader.nextLog();
        while (logType != null) {
            if (desiredLogType == null || desiredLogType.isEmpty() || desiredLogType.equals(logType)) {
                long ret;
                long logLength = logReader.getCurrentLogLength();
                if (foundLog) {
                    ((HamletImpl.EImp)((Object)((Hamlet.PRE)html.pre())._(new Object[]{"\n\n"})))._();
                }
                ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{"Log Type: " + logType})))._();
                ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{"Log Upload Time: " + Times.format(logUpLoadTime)})))._();
                ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{"Log Length: " + Long.toString(logLength)})))._();
                long start = logLimits.start < 0L ? logLength + logLimits.start : logLimits.start;
                start = start < 0L ? 0L : start;
                start = start > logLength ? logLength : start;
                long end = logLimits.end < 0L ? logLength + logLimits.end : logLimits.end;
                end = end < 0L ? 0L : end;
                end = end > logLength ? logLength : end;
                end = end < start ? start : end;
                long toRead = end - start;
                if (toRead < logLength) {
                    ((HamletImpl.EImp)((Object)((Hamlet.P)((Hamlet.P)((Hamlet.P)html.p())._(new Object[]{"Showing " + toRead + " bytes of " + logLength + " total. Click "})).a(this.url("logs", this.$("nm.id"), this.$("container.id"), this.$("entity.string"), this.$("app.owner"), logType, "?start=0"), "here"))._(new Object[]{" for the full log."})))._();
                }
                for (long totalSkipped = 0L; totalSkipped < start; totalSkipped += ret) {
                    ret = logReader.skip(start - totalSkipped);
                    if (ret != 0L) continue;
                    int nextByte = logReader.read();
                    if (nextByte == -1) {
                        throw new IOException("Premature EOF from container log");
                    }
                    ret = 1L;
                }
                int len = 0;
                int currentToRead = toRead > (long)bufferSize ? bufferSize : (int)toRead;
                HamletSpec.PRE pre = html.pre();
                while (toRead > 0L && (len = logReader.read(cbuf, 0, currentToRead)) > 0) {
                    ((Hamlet.PRE)pre)._(new Object[]{new String(cbuf, 0, len)});
                    currentToRead = (toRead -= (long)len) > (long)bufferSize ? bufferSize : (int)toRead;
                }
                ((HamletImpl.EImp)((Object)pre))._();
                foundLog = true;
            }
            logType = logReader.nextLog();
        }
        return foundLog;
    }

    private ContainerId verifyAndGetContainerId(HtmlBlock.Block html) {
        String containerIdStr = this.$("container.id");
        if (containerIdStr == null || containerIdStr.isEmpty()) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Cannot get container logs without a ContainerId"})))._();
            return null;
        }
        ContainerId containerId = null;
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
        }
        catch (IllegalArgumentException e) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Cannot get container logs for invalid containerId: " + containerIdStr})))._();
            return null;
        }
        return containerId;
    }

    private NodeId verifyAndGetNodeId(HtmlBlock.Block html) {
        String nodeIdStr = this.$("nm.id");
        if (nodeIdStr == null || nodeIdStr.isEmpty()) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Cannot get container logs without a NodeId"})))._();
            return null;
        }
        NodeId nodeId = null;
        try {
            nodeId = NodeId.fromString((String)nodeIdStr);
        }
        catch (IllegalArgumentException e) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Cannot get container logs. Invalid nodeId: " + nodeIdStr})))._();
            return null;
        }
        return nodeId;
    }

    private String verifyAndGetAppOwner(HtmlBlock.Block html) {
        String appOwner = this.$("app.owner");
        if (appOwner == null || appOwner.isEmpty()) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Cannot get container logs without an app owner"})))._();
        }
        return appOwner;
    }

    private LogLimits verifyAndGetLogLimits(HtmlBlock.Block html) {
        String endStr;
        long start = -4096L;
        long end = Long.MAX_VALUE;
        boolean isValid = true;
        String startStr = this.$("start");
        if (startStr != null && !startStr.isEmpty()) {
            try {
                start = Long.parseLong(startStr);
            }
            catch (NumberFormatException e) {
                isValid = false;
                ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Invalid log start value: " + startStr})))._();
            }
        }
        if ((endStr = this.$("end")) != null && !endStr.isEmpty()) {
            try {
                end = Long.parseLong(endStr);
            }
            catch (NumberFormatException e) {
                isValid = false;
                ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1())._(new Object[]{"Invalid log end value: " + endStr})))._();
            }
        }
        if (!isValid) {
            return null;
        }
        LogLimits limits = new LogLimits();
        limits.start = start;
        limits.end = end;
        return limits;
    }

    private String getApplicationLogURL(ApplicationId applicationId) {
        String appId = applicationId.toString();
        if (appId == null || appId.isEmpty()) {
            return null;
        }
        String nodeId = this.$("nm.id");
        if (nodeId == null || nodeId.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String scheme = YarnConfiguration.useHttps((Configuration)this.conf) ? "https://" : "http://";
        sb.append(scheme).append(nodeId).append("/node/application/").append(appId);
        return sb.toString();
    }

    private static class LogLimits {
        long start;
        long end;

        private LogLimits() {
        }
    }
}

