/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.common.base.CharMatcher;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerLaunchContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.LogAggregationContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourceRequestPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ApplicationSubmissionContextPBImpl
extends ApplicationSubmissionContext {
    YarnProtos.ApplicationSubmissionContextProto proto = YarnProtos.ApplicationSubmissionContextProto.getDefaultInstance();
    YarnProtos.ApplicationSubmissionContextProto.Builder builder = null;
    boolean viaProto = false;
    private ApplicationId applicationId = null;
    private Priority priority = null;
    private ContainerLaunchContext amContainer = null;
    private Resource resource = null;
    private Set<String> applicationTags = null;
    private ResourceRequest amResourceRequest = null;
    private LogAggregationContext logAggregationContext = null;
    private ReservationId reservationId = null;
    private Map<ApplicationTimeoutType, Long> applicationTimeouts = null;

    public ApplicationSubmissionContextPBImpl() {
        this.builder = YarnProtos.ApplicationSubmissionContextProto.newBuilder();
    }

    public ApplicationSubmissionContextPBImpl(YarnProtos.ApplicationSubmissionContextProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ApplicationSubmissionContextProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((ApplicationSubmissionContextPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.applicationId != null) {
            this.builder.setApplicationId(this.convertToProtoFormat(this.applicationId));
        }
        if (this.priority != null) {
            this.builder.setPriority(this.convertToProtoFormat(this.priority));
        }
        if (this.amContainer != null) {
            this.builder.setAmContainerSpec(this.convertToProtoFormat(this.amContainer));
        }
        if (this.resource != null && !((ResourcePBImpl)this.resource).getProto().equals((Object)this.builder.getResource())) {
            this.builder.setResource(this.convertToProtoFormat(this.resource));
        }
        if (this.applicationTags != null && !this.applicationTags.isEmpty()) {
            this.builder.clearApplicationTags();
            this.builder.addAllApplicationTags(this.applicationTags);
        }
        if (this.amResourceRequest != null) {
            this.builder.setAmContainerResourceRequest(this.convertToProtoFormat(this.amResourceRequest));
        }
        if (this.logAggregationContext != null) {
            this.builder.setLogAggregationContext(this.convertToProtoFormat(this.logAggregationContext));
        }
        if (this.reservationId != null) {
            this.builder.setReservationId(this.convertToProtoFormat(this.reservationId));
        }
        if (this.applicationTimeouts != null) {
            this.addApplicationTimeouts();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ApplicationSubmissionContextProto.newBuilder((YarnProtos.ApplicationSubmissionContextProto)this.proto);
        }
        this.viaProto = false;
    }

    public Priority getPriority() {
        YarnProtos.ApplicationSubmissionContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.priority != null) {
            return this.priority;
        }
        if (!p.hasPriority()) {
            return null;
        }
        this.priority = this.convertFromProtoFormat(p.getPriority());
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.maybeInitBuilder();
        if (priority == null) {
            this.builder.clearPriority();
        }
        this.priority = priority;
    }

    public ApplicationId getApplicationId() {
        YarnProtos.ApplicationSubmissionContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.applicationId != null) {
            return this.applicationId;
        }
        if (!p.hasApplicationId()) {
            return null;
        }
        this.applicationId = this.convertFromProtoFormat(p.getApplicationId());
        return this.applicationId;
    }

    public void setApplicationId(ApplicationId applicationId) {
        this.maybeInitBuilder();
        if (applicationId == null) {
            this.builder.clearApplicationId();
        }
        this.applicationId = applicationId;
    }

    public String getApplicationName() {
        YarnProtos.ApplicationSubmissionContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasApplicationName()) {
            return null;
        }
        return p.getApplicationName();
    }

    public void setApplicationName(String applicationName) {
        this.maybeInitBuilder();
        if (applicationName == null) {
            this.builder.clearApplicationName();
            return;
        }
        this.builder.setApplicationName(applicationName);
    }

    public String getQueue() {
        YarnProtos.ApplicationSubmissionContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasQueue()) {
            return null;
        }
        return p.getQueue();
    }

    public String getApplicationType() {
        YarnProtos.ApplicationSubmissionContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasApplicationType()) {
            return null;
        }
        return p.getApplicationType();
    }

    private void initApplicationTags() {
        if (this.applicationTags != null) {
            return;
        }
        YarnProtos.ApplicationSubmissionContextProto p = this.viaProto ? this.proto : this.builder;
        this.applicationTags = new HashSet<String>();
        this.applicationTags.addAll(p.getApplicationTagsList());
    }

    public Set<String> getApplicationTags() {
        this.initApplicationTags();
        return this.applicationTags;
    }

    public void setQueue(String queue) {
        this.maybeInitBuilder();
        if (queue == null) {
            this.builder.clearQueue();
            return;
        }
        this.builder.setQueue(queue);
    }

    public void setApplicationType(String applicationType) {
        this.maybeInitBuilder();
        if (applicationType == null) {
            this.builder.clearApplicationType();
            return;
        }
        this.builder.setApplicationType(applicationType);
    }

    private void checkTags(Set<String> tags) {
        if (tags.size() > 10) {
            throw new IllegalArgumentException("Too many applicationTags, a maximum of only 10 are allowed!");
        }
        for (String tag : tags) {
            if (tag.length() > 100) {
                throw new IllegalArgumentException("Tag " + tag + " is too long, maximum allowed length of a tag is " + 100);
            }
            if (CharMatcher.ASCII.matchesAllOf((CharSequence)tag)) continue;
            throw new IllegalArgumentException("A tag can only have ASCII characters! Invalid tag - " + tag);
        }
    }

    public void setApplicationTags(Set<String> tags) {
        this.maybeInitBuilder();
        if (tags == null || tags.isEmpty()) {
            this.builder.clearApplicationTags();
            this.applicationTags = null;
            return;
        }
        this.checkTags(tags);
        this.applicationTags = new HashSet<String>();
        for (String tag : tags) {
            this.applicationTags.add(StringUtils.toLowerCase((String)tag));
        }
    }

    public ContainerLaunchContext getAMContainerSpec() {
        YarnProtos.ApplicationSubmissionContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.amContainer != null) {
            return this.amContainer;
        }
        if (!p.hasAmContainerSpec()) {
            return null;
        }
        this.amContainer = this.convertFromProtoFormat(p.getAmContainerSpec());
        return this.amContainer;
    }

    public void setAMContainerSpec(ContainerLaunchContext amContainer) {
        this.maybeInitBuilder();
        if (amContainer == null) {
            this.builder.clearAmContainerSpec();
        }
        this.amContainer = amContainer;
    }

    public boolean getUnmanagedAM() {
        YarnProtos.ApplicationSubmissionContextProto p = this.viaProto ? this.proto : this.builder;
        return p.getUnmanagedAm();
    }

    public void setUnmanagedAM(boolean value) {
        this.maybeInitBuilder();
        this.builder.setUnmanagedAm(value);
    }

    public boolean getCancelTokensWhenComplete() {
        YarnProtos.ApplicationSubmissionContextProto p = this.viaProto ? this.proto : this.builder;
        return p.getCancelTokensWhenComplete();
    }

    public void setCancelTokensWhenComplete(boolean cancel) {
        this.maybeInitBuilder();
        this.builder.setCancelTokensWhenComplete(cancel);
    }

    public int getMaxAppAttempts() {
        YarnProtos.ApplicationSubmissionContextProto p = this.viaProto ? this.proto : this.builder;
        return p.getMaxAppAttempts();
    }

    public void setMaxAppAttempts(int maxAppAttempts) {
        this.maybeInitBuilder();
        this.builder.setMaxAppAttempts(maxAppAttempts);
    }

    public Resource getResource() {
        YarnProtos.ApplicationSubmissionContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.resource != null) {
            return this.resource;
        }
        if (!p.hasResource()) {
            return null;
        }
        this.resource = this.convertFromProtoFormat(p.getResource());
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.maybeInitBuilder();
        if (resource == null) {
            this.builder.clearResource();
        }
        this.resource = resource;
    }

    public ReservationId getReservationID() {
        YarnProtos.ApplicationSubmissionContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.reservationId != null) {
            return this.reservationId;
        }
        if (!p.hasReservationId()) {
            return null;
        }
        this.reservationId = this.convertFromProtoFormat(p.getReservationId());
        return this.reservationId;
    }

    public void setReservationID(ReservationId reservationID) {
        this.maybeInitBuilder();
        if (reservationID == null) {
            this.builder.clearReservationId();
            return;
        }
        this.reservationId = reservationID;
    }

    public void setKeepContainersAcrossApplicationAttempts(boolean keepContainers) {
        this.maybeInitBuilder();
        this.builder.setKeepContainersAcrossApplicationAttempts(keepContainers);
    }

    public boolean getKeepContainersAcrossApplicationAttempts() {
        YarnProtos.ApplicationSubmissionContextProto p = this.viaProto ? this.proto : this.builder;
        return p.getKeepContainersAcrossApplicationAttempts();
    }

    private PriorityPBImpl convertFromProtoFormat(YarnProtos.PriorityProto p) {
        return new PriorityPBImpl(p);
    }

    private YarnProtos.PriorityProto convertToProtoFormat(Priority t) {
        return ((PriorityPBImpl)t).getProto();
    }

    private ResourceRequestPBImpl convertFromProtoFormat(YarnProtos.ResourceRequestProto p) {
        return new ResourceRequestPBImpl(p);
    }

    private YarnProtos.ResourceRequestProto convertToProtoFormat(ResourceRequest t) {
        return ((ResourceRequestPBImpl)t).getProto();
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto p) {
        return new ApplicationIdPBImpl(p);
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t) {
        return ((ApplicationIdPBImpl)t).getProto();
    }

    private ContainerLaunchContextPBImpl convertFromProtoFormat(YarnProtos.ContainerLaunchContextProto p) {
        return new ContainerLaunchContextPBImpl(p);
    }

    private YarnProtos.ContainerLaunchContextProto convertToProtoFormat(ContainerLaunchContext t) {
        return ((ContainerLaunchContextPBImpl)t).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t) {
        return ((ResourcePBImpl)t).getProto();
    }

    public String getNodeLabelExpression() {
        YarnProtos.ApplicationSubmissionContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeLabelExpression()) {
            return null;
        }
        return p.getNodeLabelExpression();
    }

    public void setNodeLabelExpression(String labelExpression) {
        this.maybeInitBuilder();
        if (labelExpression == null) {
            this.builder.clearNodeLabelExpression();
            return;
        }
        this.builder.setNodeLabelExpression(labelExpression);
    }

    public ResourceRequest getAMContainerResourceRequest() {
        YarnProtos.ApplicationSubmissionContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.amResourceRequest != null) {
            return this.amResourceRequest;
        }
        if (!p.hasAmContainerResourceRequest()) {
            return null;
        }
        this.amResourceRequest = this.convertFromProtoFormat(p.getAmContainerResourceRequest());
        return this.amResourceRequest;
    }

    public void setAMContainerResourceRequest(ResourceRequest request) {
        this.maybeInitBuilder();
        if (request == null) {
            this.builder.clearAmContainerResourceRequest();
        }
        this.amResourceRequest = request;
    }

    public long getAttemptFailuresValidityInterval() {
        YarnProtos.ApplicationSubmissionContextProto p = this.viaProto ? this.proto : this.builder;
        return p.getAttemptFailuresValidityInterval();
    }

    public void setAttemptFailuresValidityInterval(long attemptFailuresValidityInterval) {
        this.maybeInitBuilder();
        this.builder.setAttemptFailuresValidityInterval(attemptFailuresValidityInterval);
    }

    private LogAggregationContextPBImpl convertFromProtoFormat(YarnProtos.LogAggregationContextProto p) {
        return new LogAggregationContextPBImpl(p);
    }

    private YarnProtos.LogAggregationContextProto convertToProtoFormat(LogAggregationContext t) {
        return ((LogAggregationContextPBImpl)t).getProto();
    }

    public LogAggregationContext getLogAggregationContext() {
        YarnProtos.ApplicationSubmissionContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.logAggregationContext != null) {
            return this.logAggregationContext;
        }
        if (!p.hasLogAggregationContext()) {
            return null;
        }
        this.logAggregationContext = this.convertFromProtoFormat(p.getLogAggregationContext());
        return this.logAggregationContext;
    }

    public void setLogAggregationContext(LogAggregationContext logAggregationContext) {
        this.maybeInitBuilder();
        if (logAggregationContext == null) {
            this.builder.clearLogAggregationContext();
        }
        this.logAggregationContext = logAggregationContext;
    }

    private ReservationIdPBImpl convertFromProtoFormat(YarnProtos.ReservationIdProto p) {
        return new ReservationIdPBImpl(p);
    }

    private YarnProtos.ReservationIdProto convertToProtoFormat(ReservationId t) {
        return ((ReservationIdPBImpl)t).getProto();
    }

    public Map<ApplicationTimeoutType, Long> getApplicationTimeouts() {
        this.initApplicationTimeout();
        return this.applicationTimeouts;
    }

    private void initApplicationTimeout() {
        if (this.applicationTimeouts != null) {
            return;
        }
        YarnProtos.ApplicationSubmissionContextProto p = this.viaProto ? this.proto : this.builder;
        List lists = p.getApplicationTimeoutsList();
        this.applicationTimeouts = new HashMap<ApplicationTimeoutType, Long>(lists.size());
        for (YarnProtos.ApplicationTimeoutMapProto timeoutProto : lists) {
            this.applicationTimeouts.put(ProtoUtils.convertFromProtoFormat(timeoutProto.getApplicationTimeoutType()), timeoutProto.getTimeout());
        }
    }

    public void setApplicationTimeouts(Map<ApplicationTimeoutType, Long> appTimeouts) {
        if (appTimeouts == null) {
            return;
        }
        this.initApplicationTimeout();
        this.applicationTimeouts.clear();
        this.applicationTimeouts.putAll(appTimeouts);
    }

    private void addApplicationTimeouts() {
        this.maybeInitBuilder();
        this.builder.clearApplicationTimeouts();
        if (this.applicationTimeouts == null) {
            return;
        }
        Iterable<YarnProtos.ApplicationTimeoutMapProto> values = new Iterable<YarnProtos.ApplicationTimeoutMapProto>(){

            @Override
            public Iterator<YarnProtos.ApplicationTimeoutMapProto> iterator() {
                return new Iterator<YarnProtos.ApplicationTimeoutMapProto>(){
                    private Iterator<ApplicationTimeoutType> iterator;
                    {
                        this.iterator = ApplicationSubmissionContextPBImpl.this.applicationTimeouts.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public YarnProtos.ApplicationTimeoutMapProto next() {
                        ApplicationTimeoutType key = this.iterator.next();
                        return YarnProtos.ApplicationTimeoutMapProto.newBuilder().setTimeout(((Long)ApplicationSubmissionContextPBImpl.this.applicationTimeouts.get(key)).longValue()).setApplicationTimeoutType(ProtoUtils.convertToProtoFormat(key)).build();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllApplicationTimeouts((Iterable)values);
    }
}

