/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api;

import java.io.Flushable;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.client.api.impl.TimelineClientImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class TimelineClient
extends AbstractService
implements Flushable {
    private ApplicationId contextAppId;

    @InterfaceAudience.Public
    public static TimelineClient createTimelineClient() {
        TimelineClientImpl client = new TimelineClientImpl();
        return client;
    }

    @InterfaceAudience.Public
    public static TimelineClient createTimelineClient(ApplicationId appId) {
        TimelineClientImpl client = new TimelineClientImpl(appId);
        return client;
    }

    @InterfaceAudience.Private
    protected TimelineClient(String name, ApplicationId appId) {
        super(name);
        this.setContextAppId(appId);
    }

    @InterfaceAudience.Public
    public abstract TimelinePutResponse putEntities(TimelineEntity ... var1) throws IOException, YarnException;

    @InterfaceAudience.Public
    public abstract TimelinePutResponse putEntities(ApplicationAttemptId var1, TimelineEntityGroupId var2, TimelineEntity ... var3) throws IOException, YarnException;

    @InterfaceAudience.Public
    public abstract void putDomain(TimelineDomain var1) throws IOException, YarnException;

    @InterfaceAudience.Public
    public abstract void putDomain(ApplicationAttemptId var1, TimelineDomain var2) throws IOException, YarnException;

    @InterfaceAudience.Public
    public abstract Token<TimelineDelegationTokenIdentifier> getDelegationToken(String var1) throws IOException, YarnException;

    @InterfaceAudience.Public
    public abstract long renewDelegationToken(Token<TimelineDelegationTokenIdentifier> var1) throws IOException, YarnException;

    @InterfaceAudience.Public
    public abstract void cancelDelegationToken(Token<TimelineDelegationTokenIdentifier> var1) throws IOException, YarnException;

    @InterfaceAudience.Public
    public abstract void putEntities(org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity ... var1) throws IOException, YarnException;

    @InterfaceAudience.Public
    public abstract void putEntitiesAsync(org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity ... var1) throws IOException, YarnException;

    public abstract void setTimelineServiceAddress(String var1);

    protected ApplicationId getContextAppId() {
        return this.contextAppId;
    }

    protected void setContextAppId(ApplicationId appId) {
        this.contextAppId = appId;
    }
}

