/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.utils;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.hadoop.yarn.server.utils.LeveldbIterator;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.DBIterator;
import org.junit.Assert;
import org.junit.Test;

public class TestLeveldbIterator {
    private static CallInfo[] RTEXC_METHODS = new CallInfo[]{new CallInfo("seek", new Object[]{new byte[0]}), new CallInfo("seekToFirst", new Object[0]), new CallInfo("seekToLast", new Object[0]), new CallInfo("hasNext", new Object[0]), new CallInfo("next", new Object[0]), new CallInfo("peekNext", new Object[0]), new CallInfo("hasPrev", new Object[0]), new CallInfo("prev", new Object[0]), new CallInfo("peekPrev", new Object[0]), new CallInfo("remove", new Object[0])};

    @Test
    public void testExceptionHandling() throws Exception {
        InvocationHandler rtExcHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                throw new RuntimeException("forced runtime error");
            }
        };
        DBIterator dbiter = (DBIterator)Proxy.newProxyInstance(DBIterator.class.getClassLoader(), new Class[]{DBIterator.class}, rtExcHandler);
        LeveldbIterator iter = new LeveldbIterator(dbiter);
        for (CallInfo ci : RTEXC_METHODS) {
            Method method = iter.getClass().getMethod(ci.methodName, ci.argTypes);
            Assert.assertNotNull((String)("unable to locate method " + ci.methodName), (Object)method);
            try {
                method.invoke((Object)iter, ci.args);
                Assert.fail((String)"operation should have thrown");
            }
            catch (InvocationTargetException ite) {
                Throwable exc = ite.getTargetException();
                Assert.assertTrue((String)("Method " + ci.methodName + " threw non-DBException: " + exc), (boolean)(exc instanceof DBException));
                Assert.assertFalse((String)("Method " + ci.methodName + " double-wrapped DBException"), (boolean)(exc.getCause() instanceof DBException));
            }
        }
        try {
            iter.close();
            Assert.fail((String)"operation shoul have thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class CallInfo {
        String methodName;
        Object[] args;
        Class<?>[] argTypes;

        public CallInfo(String methodName, Object ... args) {
            this.methodName = methodName;
            this.args = args;
            this.argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                this.argTypes[i] = args[i].getClass();
            }
        }
    }
}

