/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.SignalContainerResponsePBImpl;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.InvalidApplicationMasterRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshClusterMaxPriorityRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshClusterMaxPriorityResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResourcesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResourcesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceResponse;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockResourceManagerFacade
implements ApplicationClientProtocol,
ApplicationMasterProtocol,
ResourceManagerAdministrationProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(MockResourceManagerFacade.class);
    private HashSet<ApplicationId> applicationMap = new HashSet();
    private HashSet<ApplicationId> keepContainerOnUams = new HashSet();
    private HashMap<ApplicationId, List<ContainerId>> applicationContainerIdMap = new HashMap();
    private int rmId;
    private AtomicInteger containerIndex = new AtomicInteger(0);
    private Configuration conf;
    private int subClusterId;
    private final AtomicInteger applicationCounter = new AtomicInteger(0);
    private boolean isRunning;
    private boolean shouldReRegisterNext = false;
    private boolean shouldWaitForSyncNextAllocate = false;
    private static Object registerSyncObj = new Object();
    private static Object allocateSyncObj = new Object();

    public static Object getRegisterSyncObj() {
        return registerSyncObj;
    }

    public static Object getAllocateSyncObj() {
        return allocateSyncObj;
    }

    public MockResourceManagerFacade(Configuration conf, int startContainerIndex) {
        this(conf, startContainerIndex, 0, true);
    }

    public MockResourceManagerFacade(Configuration conf, int startContainerIndex, int subClusterId, boolean isRunning) {
        this.conf = conf;
        this.rmId = startContainerIndex;
        this.containerIndex.set(startContainerIndex);
        this.subClusterId = subClusterId;
        this.isRunning = isRunning;
    }

    public void setShouldReRegisterNext() {
        this.shouldReRegisterNext = true;
    }

    public void setRunningMode(boolean mode) {
        this.isRunning = mode;
    }

    private static ApplicationAttemptId getAppIdentifier() throws IOException {
        AMRMTokenIdentifier result = null;
        UserGroupInformation remoteUgi = UserGroupInformation.getCurrentUser();
        Set tokenIds = remoteUgi.getTokenIdentifiers();
        for (TokenIdentifier tokenId : tokenIds) {
            if (!(tokenId instanceof AMRMTokenIdentifier)) continue;
            result = (AMRMTokenIdentifier)tokenId;
            break;
        }
        return result != null ? result.getApplicationAttemptId() : ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)0), (int)0);
    }

    private void validateRunning() throws ConnectException {
        if (!this.isRunning) {
            throw new ConnectException("RM is stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        this.validateRunning();
        ApplicationAttemptId attemptId = MockResourceManagerFacade.getAppIdentifier();
        LOG.info("Registering application attempt: " + attemptId);
        ApplicationId appId = attemptId.getApplicationId();
        ArrayList<Container> containersFromPreviousAttempt = null;
        Object object = this.applicationContainerIdMap;
        synchronized (object) {
            if (this.applicationContainerIdMap.containsKey(appId)) {
                if (this.keepContainerOnUams.contains(appId)) {
                    containersFromPreviousAttempt = new ArrayList<Container>();
                    for (ContainerId containerId : this.applicationContainerIdMap.get(appId)) {
                        containersFromPreviousAttempt.add(Container.newInstance((ContainerId)containerId, null, null, null, null, null));
                    }
                } else if (!this.shouldReRegisterNext) {
                    throw new InvalidApplicationMasterRequestException("Application Master is already registered : ");
                }
            } else {
                this.applicationContainerIdMap.put(appId, new ArrayList());
            }
        }
        this.shouldReRegisterNext = false;
        object = registerSyncObj;
        synchronized (object) {
            registerSyncObj.notifyAll();
            if (request.getRpcPort() > 1000) {
                LOG.info("Register call in RM start waiting");
                try {
                    registerSyncObj.wait();
                    LOG.info("Register call in RM wait finished");
                }
                catch (InterruptedException e) {
                    LOG.info("Register call in RM wait interrupted", (Throwable)e);
                }
            }
        }
        return RegisterApplicationMasterResponse.newInstance(null, null, null, null, containersFromPreviousAttempt, (String)request.getHost(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
        this.validateRunning();
        ApplicationAttemptId attemptId = MockResourceManagerFacade.getAppIdentifier();
        LOG.info("Finishing application attempt: " + attemptId);
        ApplicationId appId = attemptId.getApplicationId();
        if (this.shouldReRegisterNext) {
            String message = "AM is not registered, should re-register.";
            LOG.warn(message);
            throw new ApplicationMasterNotRegisteredException(message);
        }
        HashMap<ApplicationId, List<ContainerId>> hashMap = this.applicationContainerIdMap;
        synchronized (hashMap) {
            Assert.assertTrue((String)("The application id is NOT registered: " + attemptId), (boolean)this.applicationContainerIdMap.containsKey(appId));
            this.applicationContainerIdMap.remove(appId);
        }
        return FinishApplicationMasterResponse.newInstance((boolean)true);
    }

    protected ApplicationId getApplicationId(int id) {
        return ApplicationId.newInstance((long)12345L, (int)id);
    }

    protected ApplicationAttemptId getApplicationAttemptId(int id) {
        return ApplicationAttemptId.newInstance((ApplicationId)this.getApplicationId(id), (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
        this.validateRunning();
        ApplicationAttemptId attemptId = MockResourceManagerFacade.getAppIdentifier();
        LOG.info("Allocate from application attempt: " + attemptId);
        ApplicationId appId = attemptId.getApplicationId();
        if (this.shouldReRegisterNext) {
            String message = "AM is not registered, should re-register.";
            LOG.warn(message);
            throw new ApplicationMasterNotRegisteredException(message);
        }
        Object message = allocateSyncObj;
        synchronized (message) {
            if (this.shouldWaitForSyncNextAllocate) {
                this.shouldWaitForSyncNextAllocate = false;
                LOG.info("Allocate call in RM start waiting");
                try {
                    allocateSyncObj.wait();
                    LOG.info("Allocate call in RM wait finished");
                }
                catch (InterruptedException e) {
                    LOG.info("Allocate call in RM wait interrupted", (Throwable)e);
                }
            }
        }
        ArrayList<Container> containerList = new ArrayList<Container>();
        if (request.getAskList() != null) {
            for (Object rr : request.getAskList()) {
                for (int i = 0; i < rr.getNumContainers(); ++i) {
                    ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)this.getApplicationAttemptId(1), (int)this.containerIndex.incrementAndGet());
                    Container container = (Container)Records.newRecord(Container.class);
                    container.setId(containerId);
                    container.setPriority(rr.getPriority());
                    NodeId nodeId = NodeId.newInstance((String)(!Strings.isNullOrEmpty((String)rr.getResourceName()) ? rr.getResourceName() : "dummy"), (int)1000);
                    container.setNodeId(nodeId);
                    container.setResource(rr.getCapability());
                    containerList.add(container);
                    HashMap<ApplicationId, List<ContainerId>> hashMap = this.applicationContainerIdMap;
                    synchronized (hashMap) {
                        Assert.assertTrue((String)("The application id is Not registered before allocate(): " + appId), (boolean)this.applicationContainerIdMap.containsKey(appId));
                        List<ContainerId> ids = this.applicationContainerIdMap.get(appId);
                        ids.add(containerId);
                        continue;
                    }
                }
            }
        }
        ArrayList<ContainerStatus> completedList = new ArrayList<ContainerStatus>();
        if (request.getReleaseList() != null && request.getReleaseList().size() > 0) {
            Object rr;
            LOG.info("Releasing containers: " + request.getReleaseList().size());
            rr = this.applicationContainerIdMap;
            synchronized (rr) {
                Assert.assertTrue((String)("The application id is not registered before allocate(): " + appId), (boolean)this.applicationContainerIdMap.containsKey(appId));
                List<ContainerId> ids = this.applicationContainerIdMap.get(appId);
                for (ContainerId id : request.getReleaseList()) {
                    boolean found = false;
                    for (ContainerId c : ids) {
                        if (!c.equals((Object)id)) continue;
                        found = true;
                        break;
                    }
                    Assert.assertTrue((String)("ContainerId " + id + " being released is not valid for application: " + attemptId), (boolean)found);
                    ids.remove(id);
                    completedList.add(ContainerStatus.newInstance((ContainerId)id, (ContainerState)ContainerState.COMPLETE, (String)"", (int)0));
                }
            }
        }
        LOG.info("Allocating containers: " + containerList.size() + " for application attempt: " + attemptId);
        Token newAMRMToken = Token.newInstance((byte[])new byte[0], (String)Integer.toString(this.rmId), (byte[])new byte[0], (String)"");
        return AllocateResponse.newInstance((int)0, completedList, containerList, new ArrayList(), null, (AMCommand)AMCommand.AM_RESYNC, (int)1, null, new ArrayList(), (Token)newAMRMToken, new ArrayList(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWaitForSyncNextAllocate(boolean wait) {
        Object object = allocateSyncObj;
        synchronized (object) {
            this.shouldWaitForSyncNextAllocate = wait;
        }
    }

    public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnException, IOException {
        this.validateRunning();
        GetApplicationReportResponse response = (GetApplicationReportResponse)Records.newRecord(GetApplicationReportResponse.class);
        ApplicationReport report = (ApplicationReport)Records.newRecord(ApplicationReport.class);
        report.setYarnApplicationState(YarnApplicationState.ACCEPTED);
        report.setApplicationId(request.getApplicationId());
        report.setCurrentApplicationAttemptId(ApplicationAttemptId.newInstance((ApplicationId)request.getApplicationId(), (int)1));
        report.setAMRMToken(Token.newInstance((byte[])new byte[0], (String)"", (byte[])new byte[0], (String)""));
        response.setApplicationReport(report);
        return response;
    }

    public GetApplicationAttemptReportResponse getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        this.validateRunning();
        GetApplicationAttemptReportResponse response = (GetApplicationAttemptReportResponse)Records.newRecord(GetApplicationAttemptReportResponse.class);
        ApplicationAttemptReport report = (ApplicationAttemptReport)Records.newRecord(ApplicationAttemptReport.class);
        report.setApplicationAttemptId(request.getApplicationAttemptId());
        report.setYarnApplicationAttemptState(YarnApplicationAttemptState.LAUNCHED);
        response.setApplicationAttemptReport(report);
        return response;
    }

    public GetNewApplicationResponse getNewApplication(GetNewApplicationRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetNewApplicationResponse.newInstance((ApplicationId)ApplicationId.newInstance((long)this.subClusterId, (int)this.applicationCounter.incrementAndGet()), null, null);
    }

    public SubmitApplicationResponse submitApplication(SubmitApplicationRequest request) throws YarnException, IOException {
        this.validateRunning();
        ApplicationId appId = null;
        if (request.getApplicationSubmissionContext() != null) {
            appId = request.getApplicationSubmissionContext().getApplicationId();
        }
        LOG.info("Application submitted: " + appId);
        this.applicationMap.add(appId);
        if (request.getApplicationSubmissionContext().getUnmanagedAM() || request.getApplicationSubmissionContext().getKeepContainersAcrossApplicationAttempts()) {
            this.keepContainerOnUams.add(appId);
        }
        return SubmitApplicationResponse.newInstance();
    }

    public KillApplicationResponse forceKillApplication(KillApplicationRequest request) throws YarnException, IOException {
        this.validateRunning();
        ApplicationId appId = null;
        if (request.getApplicationId() != null) {
            appId = request.getApplicationId();
            if (!this.applicationMap.remove(appId)) {
                throw new ApplicationNotFoundException("Trying to kill an absent application: " + appId);
            }
            this.keepContainerOnUams.remove(appId);
        }
        LOG.info("Force killing application: " + appId);
        return KillApplicationResponse.newInstance((boolean)true);
    }

    public GetClusterMetricsResponse getClusterMetrics(GetClusterMetricsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetClusterMetricsResponse.newInstance(null);
    }

    public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetApplicationsResponse.newInstance(null);
    }

    public GetClusterNodesResponse getClusterNodes(GetClusterNodesRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetClusterNodesResponse.newInstance(null);
    }

    public GetQueueInfoResponse getQueueInfo(GetQueueInfoRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetQueueInfoResponse.newInstance(null);
    }

    public GetQueueUserAclsInfoResponse getQueueUserAcls(GetQueueUserAclsInfoRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetQueueUserAclsInfoResponse.newInstance(null);
    }

    public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetDelegationTokenResponse.newInstance(null);
    }

    public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws YarnException, IOException {
        this.validateRunning();
        return RenewDelegationTokenResponse.newInstance((long)0L);
    }

    public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws YarnException, IOException {
        this.validateRunning();
        return CancelDelegationTokenResponse.newInstance();
    }

    public MoveApplicationAcrossQueuesResponse moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest request) throws YarnException, IOException {
        this.validateRunning();
        return MoveApplicationAcrossQueuesResponse.newInstance();
    }

    public GetApplicationAttemptsResponse getApplicationAttempts(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetApplicationAttemptsResponse.newInstance(null);
    }

    public GetContainerReportResponse getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetContainerReportResponse.newInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetContainersResponse getContainers(GetContainersRequest request) throws YarnException, IOException {
        this.validateRunning();
        ApplicationId appId = request.getApplicationAttemptId().getApplicationId();
        ArrayList<ContainerReport> containers = new ArrayList<ContainerReport>();
        HashMap<ApplicationId, List<ContainerId>> hashMap = this.applicationContainerIdMap;
        synchronized (hashMap) {
            Assert.assertTrue((String)("The application id is NOT registered: " + appId), (boolean)this.applicationContainerIdMap.containsKey(appId));
            List<ContainerId> ids = this.applicationContainerIdMap.get(appId);
            for (ContainerId c : ids) {
                containers.add(ContainerReport.newInstance((ContainerId)c, null, null, null, (long)0L, (long)0L, null, null, (int)0, null, null));
            }
        }
        return GetContainersResponse.newInstance(containers);
    }

    public ReservationSubmissionResponse submitReservation(ReservationSubmissionRequest request) throws YarnException, IOException {
        this.validateRunning();
        return ReservationSubmissionResponse.newInstance();
    }

    public ReservationListResponse listReservations(ReservationListRequest request) throws YarnException, IOException {
        this.validateRunning();
        return ReservationListResponse.newInstance(new ArrayList());
    }

    public ReservationUpdateResponse updateReservation(ReservationUpdateRequest request) throws YarnException, IOException {
        this.validateRunning();
        return ReservationUpdateResponse.newInstance();
    }

    public ReservationDeleteResponse deleteReservation(ReservationDeleteRequest request) throws YarnException, IOException {
        this.validateRunning();
        return ReservationDeleteResponse.newInstance();
    }

    public GetNodesToLabelsResponse getNodeToLabels(GetNodesToLabelsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetNodesToLabelsResponse.newInstance(new HashMap());
    }

    public GetClusterNodeLabelsResponse getClusterNodeLabels(GetClusterNodeLabelsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetClusterNodeLabelsResponse.newInstance(new ArrayList());
    }

    public GetLabelsToNodesResponse getLabelsToNodes(GetLabelsToNodesRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetLabelsToNodesResponse.newInstance(null);
    }

    public GetNewReservationResponse getNewReservation(GetNewReservationRequest request) throws YarnException, IOException {
        this.validateRunning();
        return GetNewReservationResponse.newInstance((ReservationId)ReservationId.newInstance((long)0L, (long)0L));
    }

    public FailApplicationAttemptResponse failApplicationAttempt(FailApplicationAttemptRequest request) throws YarnException, IOException {
        this.validateRunning();
        return FailApplicationAttemptResponse.newInstance();
    }

    public UpdateApplicationPriorityResponse updateApplicationPriority(UpdateApplicationPriorityRequest request) throws YarnException, IOException {
        this.validateRunning();
        return UpdateApplicationPriorityResponse.newInstance(null);
    }

    public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException, IOException {
        this.validateRunning();
        return new SignalContainerResponsePBImpl();
    }

    public UpdateApplicationTimeoutsResponse updateApplicationTimeouts(UpdateApplicationTimeoutsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return UpdateApplicationTimeoutsResponse.newInstance();
    }

    public RefreshQueuesResponse refreshQueues(RefreshQueuesRequest request) throws StandbyException, YarnException, IOException {
        this.validateRunning();
        return RefreshQueuesResponse.newInstance();
    }

    public RefreshNodesResponse refreshNodes(RefreshNodesRequest request) throws StandbyException, YarnException, IOException {
        this.validateRunning();
        return RefreshNodesResponse.newInstance();
    }

    public RefreshSuperUserGroupsConfigurationResponse refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest request) throws StandbyException, YarnException, IOException {
        this.validateRunning();
        return RefreshSuperUserGroupsConfigurationResponse.newInstance();
    }

    public RefreshUserToGroupsMappingsResponse refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest request) throws StandbyException, YarnException, IOException {
        this.validateRunning();
        return RefreshUserToGroupsMappingsResponse.newInstance();
    }

    public RefreshAdminAclsResponse refreshAdminAcls(RefreshAdminAclsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return RefreshAdminAclsResponse.newInstance();
    }

    public RefreshServiceAclsResponse refreshServiceAcls(RefreshServiceAclsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return RefreshServiceAclsResponse.newInstance();
    }

    public UpdateNodeResourceResponse updateNodeResource(UpdateNodeResourceRequest request) throws YarnException, IOException {
        this.validateRunning();
        return UpdateNodeResourceResponse.newInstance();
    }

    public RefreshNodesResourcesResponse refreshNodesResources(RefreshNodesResourcesRequest request) throws YarnException, IOException {
        this.validateRunning();
        return RefreshNodesResourcesResponse.newInstance();
    }

    public AddToClusterNodeLabelsResponse addToClusterNodeLabels(AddToClusterNodeLabelsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return AddToClusterNodeLabelsResponse.newInstance();
    }

    public RemoveFromClusterNodeLabelsResponse removeFromClusterNodeLabels(RemoveFromClusterNodeLabelsRequest request) throws YarnException, IOException {
        this.validateRunning();
        return RemoveFromClusterNodeLabelsResponse.newInstance();
    }

    public ReplaceLabelsOnNodeResponse replaceLabelsOnNode(ReplaceLabelsOnNodeRequest request) throws YarnException, IOException {
        this.validateRunning();
        return ReplaceLabelsOnNodeResponse.newInstance();
    }

    public CheckForDecommissioningNodesResponse checkForDecommissioningNodes(CheckForDecommissioningNodesRequest checkForDecommissioningNodesRequest) throws YarnException, IOException {
        this.validateRunning();
        return CheckForDecommissioningNodesResponse.newInstance(null);
    }

    public RefreshClusterMaxPriorityResponse refreshClusterMaxPriority(RefreshClusterMaxPriorityRequest request) throws YarnException, IOException {
        this.validateRunning();
        return RefreshClusterMaxPriorityResponse.newInstance();
    }

    public String[] getGroupsForUser(String user) throws IOException {
        this.validateRunning();
        return new String[0];
    }

    public GetAllResourceTypeInfoResponse getResourceTypeInfo(GetAllResourceTypeInfoRequest request) throws YarnException, IOException {
        return null;
    }
}

