/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.HashMap;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.router.BaseRouterPoliciesTest;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.policies.router.LoadBasedRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLoadBasedRouterPolicy
extends BaseRouterPoliciesTest {
    @Before
    public void setUp() throws Exception {
        this.setPolicy((ConfigurableFederationPolicy)new LoadBasedRouterPolicy());
        this.setPolicyInfo(new WeightedPolicyInfo());
        HashMap<SubClusterIdInfo, Float> routerWeights = new HashMap<SubClusterIdInfo, Float>();
        HashMap<SubClusterIdInfo, Float> amrmWeights = new HashMap<SubClusterIdInfo, Float>();
        for (int i = 0; i < 20; ++i) {
            SubClusterIdInfo sc = new SubClusterIdInfo(String.format("sc%02d", i));
            SubClusterInfo federationSubClusterInfo = SubClusterInfo.newInstance((SubClusterId)sc.toId(), null, null, null, null, (long)-1L, (SubClusterState)SubClusterState.SC_RUNNING, (long)-1L, (String)this.generateClusterMetricsInfo(i));
            this.getActiveSubclusters().put(sc.toId(), federationSubClusterInfo);
            float weight = this.getRand().nextInt(2);
            if (i == 5) {
                weight = 1.0f;
            }
            if (i > 5 && !(this.getRand().nextFloat() > 0.05f)) continue;
            routerWeights.put(sc, Float.valueOf(weight));
            amrmWeights.put(sc, Float.valueOf(weight));
        }
        this.getPolicyInfo().setRouterPolicyWeights(routerWeights);
        this.getPolicyInfo().setAMRMPolicyWeights(amrmWeights);
        FederationPoliciesTestUtil.initializePolicyContext(this.getPolicy(), this.getPolicyInfo(), this.getActiveSubclusters());
    }

    private String generateClusterMetricsInfo(int id) {
        long mem = 1024 * this.getRand().nextInt(27699);
        if (id == 5) {
            mem = 28364800L;
        }
        String clusterMetrics = "{\"clusterMetrics\":{\"appsSubmitted\":65,\"appsCompleted\":64,\"appsPending\":0,\"appsRunning\":0,\"appsFailed\":0,\"appsKilled\":1,\"reservedMB\":0,\"availableMB\":" + mem + "," + "\"allocatedMB\":0,\"reservedVirtualCores\":0," + "\"availableVirtualCores\":2216,\"allocatedVirtualCores\":0," + "\"containersAllocated\":0,\"containersReserved\":0," + "\"containersPending\":0,\"totalMB\":28364800," + "\"totalVirtualCores\":2216,\"totalNodes\":278,\"lostNodes\":1," + "\"unhealthyNodes\":0,\"decommissionedNodes\":0," + "\"rebootedNodes\":0,\"activeNodes\":277}}\n";
        return clusterMetrics;
    }

    @Test
    public void testLoadIsRespected() throws YarnException {
        SubClusterId chosen = ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(this.getApplicationSubmissionContext(), null);
        Assert.assertEquals((Object)"sc05", (Object)chosen.getId());
    }
}

