/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.utils;

import java.io.File;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.resolver.DefaultSubClusterResolverImpl;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.util.Records;
import org.mockito.Matchers;
import org.mockito.Mockito;

public final class FederationPoliciesTestUtil {
    private static final String FEDR_NODE_PREFIX = "fedr-test-node-";

    private FederationPoliciesTestUtil() {
    }

    public static List<ResourceRequest> createResourceRequests(String[] hosts, int memory, int vCores, int priority, int containers, String labelExpression, boolean relaxLocality) throws YarnException {
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        for (String host : hosts) {
            ResourceRequest hostReq = FederationPoliciesTestUtil.createResourceRequest(host, memory, vCores, priority, containers, labelExpression, relaxLocality);
            reqs.add(hostReq);
            ResourceRequest rackReq = FederationPoliciesTestUtil.createResourceRequest("/default-rack", memory, vCores, priority, containers, labelExpression, relaxLocality);
            reqs.add(rackReq);
        }
        ResourceRequest offRackReq = FederationPoliciesTestUtil.createResourceRequest("*", memory, vCores, priority, containers, labelExpression, relaxLocality);
        reqs.add(offRackReq);
        return reqs;
    }

    protected static ResourceRequest createResourceRequest(String resource, int memory, int vCores, int priority, int containers, boolean relaxLocality) throws YarnException {
        return FederationPoliciesTestUtil.createResourceRequest(resource, memory, vCores, priority, containers, null, relaxLocality);
    }

    public static ResourceRequest createResourceRequest(long id, String resource, int memory, int vCores, int priority, int containers, String labelExpression, boolean relaxLocality) throws YarnException {
        ResourceRequest out = FederationPoliciesTestUtil.createResourceRequest(resource, memory, vCores, priority, containers, labelExpression, relaxLocality);
        out.setAllocationRequestId(id);
        return out;
    }

    public static ResourceRequest createResourceRequest(String resource, int memory, int vCores, int priority, int containers, String labelExpression, boolean relaxLocality) throws YarnException {
        ResourceRequest req = (ResourceRequest)Records.newRecord(ResourceRequest.class);
        req.setResourceName(resource);
        req.setNumContainers(containers);
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(priority);
        req.setPriority(pri);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemorySize((long)memory);
        capability.setVirtualCores(vCores);
        req.setCapability(capability);
        if (labelExpression != null) {
            req.setNodeLabelExpression(labelExpression);
        }
        req.setRelaxLocality(relaxLocality);
        return req;
    }

    public static void initializePolicyContext(FederationPolicyInitializationContext fpc, ConfigurableFederationPolicy policy, WeightedPolicyInfo policyInfo, Map<SubClusterId, SubClusterInfo> activeSubclusters, Configuration conf) throws YarnException {
        ByteBuffer buf = policyInfo.toByteBuffer();
        fpc.setSubClusterPolicyConfiguration(SubClusterPolicyConfiguration.newInstance((String)"queue1", (String)policy.getClass().getCanonicalName(), (ByteBuffer)buf));
        FederationStateStoreFacade facade = FederationStateStoreFacade.getInstance();
        FederationStateStore fss = (FederationStateStore)Mockito.mock(FederationStateStore.class);
        if (activeSubclusters == null) {
            activeSubclusters = new HashMap<SubClusterId, SubClusterInfo>();
        }
        GetSubClustersInfoResponse response = GetSubClustersInfoResponse.newInstance(new ArrayList<SubClusterInfo>(activeSubclusters.values()));
        Mockito.when((Object)fss.getSubClusters((GetSubClustersInfoRequest)Matchers.any(GetSubClustersInfoRequest.class))).thenReturn((Object)response);
        facade.reinitialize(fss, conf);
        fpc.setFederationStateStoreFacade(facade);
        policy.reinitialize(fpc);
    }

    public static void initializePolicyContext(ConfigurableFederationPolicy policy, WeightedPolicyInfo policyInfo, Map<SubClusterId, SubClusterInfo> activeSubclusters) throws YarnException {
        FederationPolicyInitializationContext context = new FederationPolicyInitializationContext(null, FederationPoliciesTestUtil.initResolver(), FederationPoliciesTestUtil.initFacade(), SubClusterId.newInstance((String)"homesubcluster"));
        FederationPoliciesTestUtil.initializePolicyContext(context, policy, policyInfo, activeSubclusters, new Configuration());
    }

    public static SubClusterResolver initResolver() {
        YarnConfiguration conf = new YarnConfiguration();
        DefaultSubClusterResolverImpl resolver = new DefaultSubClusterResolverImpl();
        URL url = Thread.currentThread().getContextClassLoader().getResource("nodes");
        if (url == null) {
            throw new RuntimeException("Could not find 'nodes' dummy file in classpath");
        }
        File file = new File(url.getPath());
        conf.set("yarn.federation.machine-list", file.getPath());
        resolver.setConf((Configuration)conf);
        resolver.load();
        return resolver;
    }

    public static FederationStateStoreFacade initFacade(List<SubClusterInfo> subClusterInfos, SubClusterPolicyConfiguration policyConfiguration) throws YarnException {
        FederationStateStoreFacade goodFacade = FederationStateStoreFacade.getInstance();
        FederationStateStore fss = (FederationStateStore)Mockito.mock(FederationStateStore.class);
        GetSubClustersInfoResponse response = GetSubClustersInfoResponse.newInstance(subClusterInfos);
        Mockito.when((Object)fss.getSubClusters((GetSubClustersInfoRequest)Matchers.any(GetSubClustersInfoRequest.class))).thenReturn((Object)response);
        ArrayList<SubClusterPolicyConfiguration> configurations = new ArrayList<SubClusterPolicyConfiguration>();
        configurations.add(policyConfiguration);
        GetSubClusterPoliciesConfigurationsResponse policiesResponse = GetSubClusterPoliciesConfigurationsResponse.newInstance(configurations);
        Mockito.when((Object)fss.getPoliciesConfigurations((GetSubClusterPoliciesConfigurationsRequest)Matchers.any(GetSubClusterPoliciesConfigurationsRequest.class))).thenReturn((Object)policiesResponse);
        GetSubClusterPolicyConfigurationResponse policyResponse = GetSubClusterPolicyConfigurationResponse.newInstance((SubClusterPolicyConfiguration)policyConfiguration);
        Mockito.when((Object)fss.getPolicyConfiguration((GetSubClusterPolicyConfigurationRequest)Matchers.any(GetSubClusterPolicyConfigurationRequest.class))).thenReturn((Object)policyResponse);
        goodFacade.reinitialize(fss, new Configuration());
        return goodFacade;
    }

    public static FederationStateStoreFacade initFacade() throws YarnException {
        return FederationPoliciesTestUtil.initFacade(new ArrayList<SubClusterInfo>(), (SubClusterPolicyConfiguration)Mockito.mock(SubClusterPolicyConfiguration.class));
    }
}

