/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.impl.MemoryFederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestFederationStateStoreFacade {
    private final long clusterTs = System.currentTimeMillis();
    private final int numSubClusters = 3;
    private final int numApps = 5;
    private final int numQueues = 2;
    private Configuration conf;
    private FederationStateStore stateStore;
    private FederationStateStoreTestUtil stateStoreTestUtil;
    private FederationStateStoreFacade facade = FederationStateStoreFacade.getInstance();

    @Parameterized.Parameters
    public static Collection<Boolean[]> getParameters() {
        return Arrays.asList({Boolean.FALSE}, {Boolean.TRUE});
    }

    public TestFederationStateStoreFacade(Boolean isCachingEnabled) {
        this.conf = new Configuration();
        if (!isCachingEnabled.booleanValue()) {
            this.conf.setInt("yarn.federation.cache-ttl.secs", 0);
        }
    }

    @Before
    public void setUp() throws IOException, YarnException {
        this.stateStore = new MemoryFederationStateStore();
        this.stateStore.init(this.conf);
        this.facade.reinitialize(this.stateStore, this.conf);
        this.stateStoreTestUtil = new FederationStateStoreTestUtil(this.stateStore);
        this.stateStoreTestUtil.registerSubClusters(3);
        this.stateStoreTestUtil.addAppsHomeSC(this.clusterTs, 5);
        this.stateStoreTestUtil.addPolicyConfigs(2);
    }

    @After
    public void tearDown() throws Exception {
        this.stateStore.close();
        this.stateStore = null;
    }

    @Test
    public void testGetSubCluster() throws YarnException {
        for (int i = 0; i < 3; ++i) {
            SubClusterId subClusterId = SubClusterId.newInstance((String)("SC-" + i));
            Assert.assertEquals((Object)this.stateStoreTestUtil.querySubClusterInfo(subClusterId), (Object)this.facade.getSubCluster(subClusterId));
        }
    }

    @Test
    public void testInvalidGetSubCluster() throws YarnException {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"dummy");
        Assert.assertNull((Object)this.facade.getSubCluster(subClusterId));
    }

    @Test
    public void testGetSubClusterFlushCache() throws YarnException {
        for (int i = 0; i < 3; ++i) {
            SubClusterId subClusterId = SubClusterId.newInstance((String)("SC-" + i));
            Assert.assertEquals((Object)this.stateStoreTestUtil.querySubClusterInfo(subClusterId), (Object)this.facade.getSubCluster(subClusterId, true));
        }
    }

    @Test
    public void testGetSubClusters() throws YarnException {
        Map subClusters = this.facade.getSubClusters(false);
        for (SubClusterId subClusterId : subClusters.keySet()) {
            Assert.assertEquals((Object)this.stateStoreTestUtil.querySubClusterInfo(subClusterId), subClusters.get(subClusterId));
        }
    }

    @Test
    public void testGetPolicyConfiguration() throws YarnException {
        for (int i = 0; i < 2; ++i) {
            String queue = "queue-" + i;
            Assert.assertEquals((Object)this.stateStoreTestUtil.queryPolicyConfiguration(queue), (Object)this.facade.getPolicyConfiguration(queue));
        }
    }

    @Test
    public void testInvalidGetPolicyConfiguration() throws YarnException {
        Assert.assertNull((Object)this.facade.getPolicyConfiguration("dummy"));
    }

    @Test
    public void testGetPoliciesConfigurations() throws YarnException {
        Map queuePolicies = this.facade.getPoliciesConfigurations();
        for (String queue : queuePolicies.keySet()) {
            Assert.assertEquals((Object)this.stateStoreTestUtil.queryPolicyConfiguration(queue), queuePolicies.get(queue));
        }
    }

    @Test
    public void testGetHomeSubClusterForApp() throws YarnException {
        for (int i = 0; i < 5; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)this.clusterTs, (int)i);
            Assert.assertEquals((Object)this.stateStoreTestUtil.queryApplicationHomeSC(appId), (Object)this.facade.getApplicationHomeSubCluster(appId));
        }
    }

    @Test
    public void testAddApplicationHomeSubCluster() throws YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)this.clusterTs, (int)6);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"Home1");
        ApplicationHomeSubCluster appHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId1);
        SubClusterId result = this.facade.addApplicationHomeSubCluster(appHomeSubCluster);
        Assert.assertEquals((Object)this.facade.getApplicationHomeSubCluster(appId), (Object)result);
        Assert.assertEquals((Object)subClusterId1, (Object)result);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"Home2");
        appHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId2);
        result = this.facade.addApplicationHomeSubCluster(appHomeSubCluster);
        Assert.assertEquals((Object)this.facade.getApplicationHomeSubCluster(appId), (Object)result);
        Assert.assertEquals((Object)subClusterId1, (Object)result);
    }
}

