/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.scheduler;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoteNode;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerAllocator;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerContext;
import org.apache.hadoop.yarn.server.security.BaseContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestOpportunisticContainerAllocator {
    private static final int GB = 1024;
    private OpportunisticContainerAllocator allocator = null;
    private OpportunisticContainerContext oppCntxt = null;

    @Before
    public void setup() {
        SecurityUtil.setTokenServiceUseIp((boolean)false);
        final MasterKey mKey = new MasterKey(){

            public int getKeyId() {
                return 1;
            }

            public void setKeyId(int keyId) {
            }

            public ByteBuffer getBytes() {
                return ByteBuffer.allocate(8);
            }

            public void setBytes(ByteBuffer bytes) {
            }
        };
        BaseContainerTokenSecretManager secMan = new BaseContainerTokenSecretManager(new Configuration()){

            public MasterKey getCurrentKey() {
                return mKey;
            }

            public byte[] createPassword(ContainerTokenIdentifier identifier) {
                return new byte[]{1, 2};
            }
        };
        this.allocator = new OpportunisticContainerAllocator(secMan);
        this.oppCntxt = new OpportunisticContainerContext();
        this.oppCntxt.getAppParams().setMinResource(Resource.newInstance((int)1024, (int)1));
        this.oppCntxt.getAppParams().setIncrementResource(Resource.newInstance((int)512, (int)1));
        this.oppCntxt.getAppParams().setMaxResource(Resource.newInstance((int)1024, (int)10));
    }

    @Test
    public void testSimpleAllocation() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1024), (int)1, (boolean)true, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true)));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h1", (int)1234), (String)"h1:1234", (String)"/r1")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        Assert.assertEquals((long)1L, (long)containers.size());
        Assert.assertEquals((long)0L, (long)this.oppCntxt.getOutstandingOpReqs().size());
    }

    @Test
    public void testBlacklistRejection() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(Arrays.asList("h1", "h2"), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1024), (int)1, (boolean)true, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true)));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h1", (int)1234), (String)"h1:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r2")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        Assert.assertEquals((long)0L, (long)containers.size());
        Assert.assertEquals((long)1L, (long)this.oppCntxt.getOutstandingOpReqs().size());
    }

    @Test
    public void testRoundRobinSimpleAllocation() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newBuilder().allocationRequestId(1L).priority(Priority.newInstance((int)1)).resourceName("*").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).priority(Priority.newInstance((int)1)).resourceName("*").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(3L).priority(Priority.newInstance((int)1)).resourceName("*").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h1", (int)1234), (String)"h1:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r1")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        System.out.println(containers);
        HashSet<String> allocatedHosts = new HashSet<String>();
        for (Container c : containers) {
            allocatedHosts.add(c.getNodeHttpAddress());
        }
        Assert.assertTrue((boolean)allocatedHosts.contains("h1:1234"));
        Assert.assertTrue((boolean)allocatedHosts.contains("h2:1234"));
        Assert.assertTrue((boolean)allocatedHosts.contains("h3:1234"));
        Assert.assertEquals((long)3L, (long)containers.size());
    }

    @Test
    public void testNodeLocalAllocation() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newBuilder().allocationRequestId(1L).priority(Priority.newInstance((int)1)).resourceName("/r1").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(1L).priority(Priority.newInstance((int)1)).resourceName("h1").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(1L).priority(Priority.newInstance((int)1)).resourceName("*").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).priority(Priority.newInstance((int)1)).resourceName("/r1").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).priority(Priority.newInstance((int)1)).resourceName("h1").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).priority(Priority.newInstance((int)1)).resourceName("*").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h1", (int)1234), (String)"h1:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r1")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        System.out.println(containers);
        HashSet<String> allocatedHosts = new HashSet<String>();
        for (Container c : containers) {
            allocatedHosts.add(c.getNodeHttpAddress());
        }
        Assert.assertEquals((long)2L, (long)containers.size());
        Assert.assertTrue((boolean)allocatedHosts.contains("h1:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h2:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h3:1234"));
    }

    @Test
    public void testNodeLocalAllocationSameSchedKey() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newBuilder().allocationRequestId(2L).numContainers(2).priority(Priority.newInstance((int)1)).resourceName("/r1").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).numContainers(2).priority(Priority.newInstance((int)1)).resourceName("h1").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).numContainers(2).priority(Priority.newInstance((int)1)).resourceName("*").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h1", (int)1234), (String)"h1:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r1")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        System.out.println(containers);
        HashSet<String> allocatedHosts = new HashSet<String>();
        for (Container c : containers) {
            allocatedHosts.add(c.getNodeHttpAddress());
        }
        Assert.assertEquals((long)2L, (long)containers.size());
        Assert.assertTrue((boolean)allocatedHosts.contains("h1:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h2:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h3:1234"));
    }

    @Test
    public void testSimpleRackLocalAllocation() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1024), (int)1, (boolean)true, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true)), ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"h1", (Resource)Resources.createResource((int)1024), (int)1, (boolean)true, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true)), ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"/r1", (Resource)Resources.createResource((int)1024), (int)1, (boolean)true, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true)));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r2"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h4", (int)1234), (String)"h4:1234", (String)"/r2")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        HashSet<String> allocatedHosts = new HashSet<String>();
        for (Container c : containers) {
            allocatedHosts.add(c.getNodeHttpAddress());
        }
        Assert.assertTrue((boolean)allocatedHosts.contains("h2:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h3:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h4:1234"));
        Assert.assertEquals((long)1L, (long)containers.size());
    }

    @Test
    public void testRoundRobinRackLocalAllocation() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newBuilder().allocationRequestId(1L).priority(Priority.newInstance((int)1)).resourceName("/r1").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(1L).priority(Priority.newInstance((int)1)).resourceName("h1").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(1L).priority(Priority.newInstance((int)1)).resourceName("*").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).priority(Priority.newInstance((int)1)).resourceName("/r1").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).priority(Priority.newInstance((int)1)).resourceName("h1").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build(), ResourceRequest.newBuilder().allocationRequestId(2L).priority(Priority.newInstance((int)1)).resourceName("*").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r2"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h5", (int)1234), (String)"h5:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h4", (int)1234), (String)"h4:1234", (String)"/r2")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        HashSet<String> allocatedHosts = new HashSet<String>();
        for (Container c : containers) {
            allocatedHosts.add(c.getNodeHttpAddress());
        }
        System.out.println(containers);
        Assert.assertTrue((boolean)allocatedHosts.contains("h2:1234"));
        Assert.assertTrue((boolean)allocatedHosts.contains("h5:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h3:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h4:1234"));
        Assert.assertEquals((long)2L, (long)containers.size());
    }

    @Test
    public void testRoundRobinRackLocalAllocationSameSchedKey() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1024), (int)2, (boolean)true, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true)), ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"h1", (Resource)Resources.createResource((int)1024), (int)2, (boolean)true, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true)), ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"/r1", (Resource)Resources.createResource((int)1024), (int)2, (boolean)true, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true)));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r2"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h5", (int)1234), (String)"h5:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h4", (int)1234), (String)"h4:1234", (String)"/r2")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        HashSet<String> allocatedHosts = new HashSet<String>();
        for (Container c : containers) {
            allocatedHosts.add(c.getNodeHttpAddress());
        }
        System.out.println(containers);
        Assert.assertTrue((boolean)allocatedHosts.contains("h2:1234"));
        Assert.assertTrue((boolean)allocatedHosts.contains("h5:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h3:1234"));
        Assert.assertFalse((boolean)allocatedHosts.contains("h4:1234"));
        Assert.assertEquals((long)2L, (long)containers.size());
    }

    @Test
    public void testOffSwitchAllocationWhenNoNodeOrRack() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1024), (int)2, (boolean)true, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true)), ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"h6", (Resource)Resources.createResource((int)1024), (int)2, (boolean)true, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true)), ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"/r3", (Resource)Resources.createResource((int)1024), (int)2, (boolean)true, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true)));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r2"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h5", (int)1234), (String)"h5:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h4", (int)1234), (String)"h4:1234", (String)"/r2")));
        List containers = this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser");
        System.out.println(containers);
        Assert.assertEquals((long)2L, (long)containers.size());
    }

    @Test
    public void testLotsOfContainersRackLocalAllocationSameSchedKey() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        List<ResourceRequest> reqs = Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)1024), (int)1000, (boolean)true, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true)), ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"h1", (Resource)Resources.createResource((int)1024), (int)1000, (boolean)true, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true)), ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"/r1", (Resource)Resources.createResource((int)1024), (int)1000, (boolean)true, null, (ExecutionTypeRequest)ExecutionTypeRequest.newInstance((ExecutionType)ExecutionType.OPPORTUNISTIC, (boolean)true)));
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r2"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h5", (int)1234), (String)"h5:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h4", (int)1234), (String)"h4:1234", (String)"/r2")));
        ArrayList containers = new ArrayList();
        for (int i = 0; i < 250; ++i) {
            containers.addAll(this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser"));
        }
        Assert.assertEquals((long)1000L, (long)containers.size());
    }

    @Test
    public void testLotsOfContainersRackLocalAllocation() throws Exception {
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(), new ArrayList());
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        for (int i = 0; i < 100; ++i) {
            reqs.add(ResourceRequest.newBuilder().allocationRequestId((long)(i + 1)).priority(Priority.newInstance((int)1)).resourceName("*").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
            reqs.add(ResourceRequest.newBuilder().allocationRequestId((long)(i + 1)).priority(Priority.newInstance((int)1)).resourceName("h1").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
            reqs.add(ResourceRequest.newBuilder().allocationRequestId((long)(i + 1)).priority(Priority.newInstance((int)1)).resourceName("/r1").capability(Resources.createResource((int)1024)).relaxLocality(true).executionType(ExecutionType.OPPORTUNISTIC).build());
        }
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        this.oppCntxt.updateNodeList(Arrays.asList(RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h3", (int)1234), (String)"h3:1234", (String)"/r2"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h2", (int)1234), (String)"h2:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h5", (int)1234), (String)"h5:1234", (String)"/r1"), RemoteNode.newInstance((NodeId)NodeId.newInstance((String)"h4", (int)1234), (String)"h4:1234", (String)"/r2")));
        ArrayList containers = new ArrayList();
        for (int i = 0; i < 25; ++i) {
            containers.addAll(this.allocator.allocateContainers(blacklistRequest, reqs, appAttId, this.oppCntxt, 1L, "luser"));
        }
        Assert.assertEquals((long)100L, (long)containers.size());
    }
}

