/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.scheduler;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoteNode;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerContext;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.security.BaseContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class OpportunisticContainerAllocator {
    private static final Log LOG = LogFactory.getLog(OpportunisticContainerAllocator.class);
    private static final ResourceCalculator RESOURCE_CALCULATOR = new DominantResourceCalculator();
    private final BaseContainerTokenSecretManager tokenSecretManager;

    public OpportunisticContainerAllocator(BaseContainerTokenSecretManager tokenSecretManager) {
        this.tokenSecretManager = tokenSecretManager;
    }

    public List<Container> allocateContainers(ResourceBlacklistRequest blackList, List<ResourceRequest> oppResourceReqs, ApplicationAttemptId applicationAttemptId, OpportunisticContainerContext opportContext, long rmIdentifier, String appSubmitter) throws YarnException {
        if (blackList != null) {
            opportContext.getBlacklist().removeAll(blackList.getBlacklistRemovals());
            opportContext.getBlacklist().addAll(blackList.getBlacklistAdditions());
        }
        opportContext.addToOutstandingReqs(oppResourceReqs);
        ArrayList<Container> allocatedContainers = new ArrayList<Container>();
        for (SchedulerRequestKey schedulerKey : opportContext.getOutstandingOpReqs().descendingKeySet()) {
            Map<Resource, List<Container>> allocated = this.allocate(rmIdentifier, opportContext, schedulerKey, applicationAttemptId, appSubmitter);
            for (Map.Entry<Resource, List<Container>> e : allocated.entrySet()) {
                opportContext.matchAllocationToOutstandingRequest(e.getKey(), e.getValue());
                allocatedContainers.addAll((Collection<Container>)e.getValue());
            }
        }
        return allocatedContainers;
    }

    private Map<Resource, List<Container>> allocate(long rmIdentifier, OpportunisticContainerContext appContext, SchedulerRequestKey schedKey, ApplicationAttemptId appAttId, String userName) throws YarnException {
        HashMap<Resource, List<Container>> containers = new HashMap<Resource, List<Container>>();
        for (ResourceRequest anyAsk : appContext.getOutstandingOpReqs().get(schedKey).values()) {
            this.allocateContainersInternal(rmIdentifier, appContext.getAppParams(), appContext.getContainerIdGenerator(), appContext.getBlacklist(), appAttId, appContext.getNodeMap(), userName, containers, anyAsk);
            if (containers.isEmpty()) continue;
            LOG.info((Object)("Opportunistic allocation requested for [priority=" + anyAsk.getPriority() + ", allocationRequestId=" + anyAsk.getAllocationRequestId() + ", num_containers=" + anyAsk.getNumContainers() + ", capability=" + anyAsk.getCapability() + "] allocated = " + containers.keySet()));
        }
        return containers;
    }

    private void allocateContainersInternal(long rmIdentifier, AllocationParams appParams, ContainerIdGenerator idCounter, Set<String> blacklist, ApplicationAttemptId id, Map<String, RemoteNode> allNodes, String userName, Map<Resource, List<Container>> containers, ResourceRequest anyAsk) throws YarnException {
        int toAllocate = anyAsk.getNumContainers() - (containers.isEmpty() ? 0 : containers.get(anyAsk.getCapability()).size());
        ArrayList<RemoteNode> nodesForScheduling = new ArrayList<RemoteNode>();
        for (Map.Entry<String, RemoteNode> nodeEntry : allNodes.entrySet()) {
            if (blacklist.contains(nodeEntry.getKey())) continue;
            nodesForScheduling.add(nodeEntry.getValue());
        }
        if (nodesForScheduling.isEmpty()) {
            LOG.warn((Object)("No nodes available for allocating opportunistic containers. [allNodes=" + allNodes + ", blacklist=" + blacklist + "]"));
            return;
        }
        int numAllocated = 0;
        int nextNodeToSchedule = 0;
        for (int numCont = 0; numCont < toAllocate; ++numCont) {
            ++nextNodeToSchedule;
            RemoteNode node = (RemoteNode)nodesForScheduling.get(nextNodeToSchedule %= nodesForScheduling.size());
            Container container = this.buildContainer(rmIdentifier, appParams, idCounter, anyAsk, id, userName, node);
            List<Container> cList = containers.get(anyAsk.getCapability());
            if (cList == null) {
                cList = new ArrayList<Container>();
                containers.put(anyAsk.getCapability(), cList);
            }
            cList.add(container);
            ++numAllocated;
            LOG.info((Object)("Allocated [" + container.getId() + "] as opportunistic."));
        }
        LOG.info((Object)("Allocated " + numAllocated + " opportunistic containers."));
    }

    private Container buildContainer(long rmIdentifier, AllocationParams appParams, ContainerIdGenerator idCounter, ResourceRequest rr, ApplicationAttemptId id, String userName, RemoteNode node) throws YarnException {
        ContainerId cId = ContainerId.newContainerId((ApplicationAttemptId)id, (long)idCounter.generateContainerId());
        Resource capability = this.normalizeCapability(appParams, rr);
        return this.createContainer(rmIdentifier, appParams.getContainerTokenExpiryInterval(), SchedulerRequestKey.create(rr), userName, node, cId, capability);
    }

    private Container createContainer(long rmIdentifier, long tokenExpiry, SchedulerRequestKey schedulerKey, String userName, RemoteNode node, ContainerId cId, Resource capability) {
        long currTime = System.currentTimeMillis();
        ContainerTokenIdentifier containerTokenIdentifier = new ContainerTokenIdentifier(cId, 0, node.getNodeId().toString(), userName, capability, currTime + tokenExpiry, this.tokenSecretManager.getCurrentKey().getKeyId(), rmIdentifier, schedulerKey.getPriority(), currTime, null, "", ContainerType.TASK, ExecutionType.OPPORTUNISTIC);
        byte[] pwd = this.tokenSecretManager.createPassword(containerTokenIdentifier);
        Token containerToken = OpportunisticContainerAllocator.newContainerToken(node.getNodeId(), pwd, containerTokenIdentifier);
        Container container = BuilderUtils.newContainer(cId, node.getNodeId(), node.getHttpAddress(), capability, schedulerKey.getPriority(), containerToken, containerTokenIdentifier.getExecutionType(), schedulerKey.getAllocationRequestId());
        return container;
    }

    private Resource normalizeCapability(AllocationParams appParams, ResourceRequest ask) {
        return Resources.normalize((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)ask.getCapability(), (Resource)appParams.minResource, (Resource)appParams.maxResource, (Resource)appParams.incrementResource);
    }

    private static Token newContainerToken(NodeId nodeId, byte[] password, ContainerTokenIdentifier tokenIdentifier) {
        InetSocketAddress addr = NetUtils.createSocketAddrForHost((String)nodeId.getHost(), (int)nodeId.getPort());
        Token containerToken = Token.newInstance((byte[])tokenIdentifier.getBytes(), (String)ContainerTokenIdentifier.KIND.toString(), (byte[])password, (String)SecurityUtil.buildTokenService((InetSocketAddress)addr).toString());
        return containerToken;
    }

    public PartitionedResourceRequests partitionAskList(List<ResourceRequest> askList) {
        PartitionedResourceRequests partitionedRequests = new PartitionedResourceRequests();
        for (ResourceRequest rr : askList) {
            if (rr.getExecutionTypeRequest().getExecutionType() == ExecutionType.OPPORTUNISTIC) {
                partitionedRequests.getOpportunistic().add(rr);
                continue;
            }
            partitionedRequests.getGuaranteed().add(rr);
        }
        return partitionedRequests;
    }

    public static class PartitionedResourceRequests {
        private List<ResourceRequest> guaranteed = new ArrayList<ResourceRequest>();
        private List<ResourceRequest> opportunistic = new ArrayList<ResourceRequest>();

        public List<ResourceRequest> getGuaranteed() {
            return this.guaranteed;
        }

        public List<ResourceRequest> getOpportunistic() {
            return this.opportunistic;
        }
    }

    public static class ContainerIdGenerator {
        protected volatile AtomicLong containerIdCounter = new AtomicLong(1L);

        public void resetContainerIdCounter(long containerIdStart) {
            this.containerIdCounter.set(containerIdStart);
        }

        public long generateContainerId() {
            return this.containerIdCounter.incrementAndGet();
        }
    }

    public static class AllocationParams {
        private Resource maxResource;
        private Resource minResource;
        private Resource incrementResource;
        private int containerTokenExpiryInterval;

        public Resource getMaxResource() {
            return this.maxResource;
        }

        public void setMaxResource(Resource maxResource) {
            this.maxResource = maxResource;
        }

        public Resource getMinResource() {
            return this.minResource;
        }

        public void setMinResource(Resource minResource) {
            this.minResource = minResource;
        }

        public Resource getIncrementResource() {
            return this.incrementResource;
        }

        public void setIncrementResource(Resource incrementResource) {
            this.incrementResource = incrementResource;
        }

        public int getContainerTokenExpiryInterval() {
            return this.containerTokenExpiryInterval;
        }

        public void setContainerTokenExpiryInterval(int containerTokenExpiryInterval) {
            this.containerTokenExpiryInterval = containerTokenExpiryInterval;
        }
    }
}

