/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy.amfilter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmFilterInitializer;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.junit.Test;

public class TestAmFilterInitializer
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        NetUtils.addStaticResolution((String)"host1", (String)"172.0.0.1");
        NetUtils.addStaticResolution((String)"host2", (String)"172.0.0.1");
        NetUtils.addStaticResolution((String)"host3", (String)"172.0.0.1");
        NetUtils.addStaticResolution((String)"host4", (String)"172.0.0.1");
        NetUtils.addStaticResolution((String)"host5", (String)"172.0.0.1");
        NetUtils.addStaticResolution((String)"host6", (String)"172.0.0.1");
    }

    @Test
    public void testInitFilter() {
        MockFilterContainer con = new MockFilterContainer();
        Configuration conf = new Configuration(false);
        conf.set("yarn.web-proxy.address", "host1:1000");
        MockAmFilterInitializer afi = new MockAmFilterInitializer();
        TestAmFilterInitializer.assertNull(con.givenParameters);
        afi.initFilter(con, conf);
        TestAmFilterInitializer.assertEquals((int)2, (int)con.givenParameters.size());
        TestAmFilterInitializer.assertEquals((String)"host1", (String)con.givenParameters.get("PROXY_HOSTS"));
        TestAmFilterInitializer.assertEquals((String)"http://host1:1000/foo", (String)con.givenParameters.get("PROXY_URI_BASES"));
        con = new MockFilterContainer();
        conf = new Configuration(false);
        conf.set("yarn.resourcemanager.webapp.address", "host2:2000");
        afi = new MockAmFilterInitializer();
        TestAmFilterInitializer.assertNull(con.givenParameters);
        afi.initFilter(con, conf);
        TestAmFilterInitializer.assertEquals((int)2, (int)con.givenParameters.size());
        TestAmFilterInitializer.assertEquals((String)"host2", (String)con.givenParameters.get("PROXY_HOSTS"));
        TestAmFilterInitializer.assertEquals((String)"http://host2:2000/foo", (String)con.givenParameters.get("PROXY_URI_BASES"));
        con = new MockFilterContainer();
        conf = new Configuration(false);
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2,rm3");
        conf.set("yarn.resourcemanager.webapp.address.rm1", "host2:2000");
        conf.set("yarn.resourcemanager.webapp.address.rm2", "host3:3000");
        conf.set("yarn.resourcemanager.webapp.address.rm3", "host4:4000");
        afi = new MockAmFilterInitializer();
        TestAmFilterInitializer.assertNull(con.givenParameters);
        afi.initFilter(con, conf);
        TestAmFilterInitializer.assertEquals((int)2, (int)con.givenParameters.size());
        Object[] proxyHosts = con.givenParameters.get("PROXY_HOSTS").split(",");
        TestAmFilterInitializer.assertEquals((int)3, (int)proxyHosts.length);
        Arrays.sort(proxyHosts);
        TestAmFilterInitializer.assertEquals((String)"host2", (String)proxyHosts[0]);
        TestAmFilterInitializer.assertEquals((String)"host3", (String)proxyHosts[1]);
        TestAmFilterInitializer.assertEquals((String)"host4", (String)proxyHosts[2]);
        Object[] proxyBases = con.givenParameters.get("PROXY_URI_BASES").split(",");
        TestAmFilterInitializer.assertEquals((int)3, (int)proxyBases.length);
        Arrays.sort(proxyBases);
        TestAmFilterInitializer.assertEquals((String)"http://host2:2000/foo", (String)proxyBases[0]);
        TestAmFilterInitializer.assertEquals((String)"http://host3:3000/foo", (String)proxyBases[1]);
        TestAmFilterInitializer.assertEquals((String)"http://host4:4000/foo", (String)proxyBases[2]);
        con = new MockFilterContainer();
        conf = new Configuration(false);
        conf.set("yarn.http.policy", HttpConfig.Policy.HTTPS_ONLY.toString());
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        conf.set("yarn.resourcemanager.webapp.https.address.rm1", "host5:5000");
        conf.set("yarn.resourcemanager.webapp.https.address.rm2", "host6:6000");
        afi = new MockAmFilterInitializer();
        TestAmFilterInitializer.assertNull(con.givenParameters);
        afi.initFilter(con, conf);
        TestAmFilterInitializer.assertEquals((int)2, (int)con.givenParameters.size());
        proxyHosts = con.givenParameters.get("PROXY_HOSTS").split(",");
        TestAmFilterInitializer.assertEquals((int)2, (int)proxyHosts.length);
        Arrays.sort(proxyHosts);
        TestAmFilterInitializer.assertEquals((String)"host5", (String)proxyHosts[0]);
        TestAmFilterInitializer.assertEquals((String)"host6", (String)proxyHosts[1]);
        proxyBases = con.givenParameters.get("PROXY_URI_BASES").split(",");
        TestAmFilterInitializer.assertEquals((int)2, (int)proxyBases.length);
        Arrays.sort(proxyBases);
        TestAmFilterInitializer.assertEquals((String)"https://host5:5000/foo", (String)proxyBases[0]);
        TestAmFilterInitializer.assertEquals((String)"https://host6:6000/foo", (String)proxyBases[1]);
    }

    @Test
    public void testGetProxyHostsAndPortsForAmFilter() {
        Configuration conf = new Configuration(false);
        List proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        TestAmFilterInitializer.assertEquals((int)1, (int)proxyHosts.size());
        TestAmFilterInitializer.assertEquals((String)WebAppUtils.getResolvedRMWebAppURLWithoutScheme((Configuration)conf), (String)((String)proxyHosts.get(0)));
        conf = new Configuration(false);
        conf.set("yarn.resourcemanager.webapp.address", "${yarn.resourcemanager.hostname}:8088");
        conf.set("yarn.resourcemanager.hostname", "host1");
        proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        TestAmFilterInitializer.assertEquals((int)1, (int)proxyHosts.size());
        TestAmFilterInitializer.assertEquals((String)"host1:8088", (String)((String)proxyHosts.get(0)));
        conf = new Configuration(false);
        conf.set("yarn.web-proxy.address", "host1:1000");
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2,rm3");
        conf.set("yarn.resourcemanager.webapp.address.rm1", "host2:2000");
        conf.set("yarn.resourcemanager.webapp.address.rm2", "host3:3000");
        conf.set("yarn.resourcemanager.webapp.address.rm3", "host4:4000");
        proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        TestAmFilterInitializer.assertEquals((int)1, (int)proxyHosts.size());
        TestAmFilterInitializer.assertEquals((String)"host1:1000", (String)((String)proxyHosts.get(0)));
        conf = new Configuration(false);
        conf.set("yarn.resourcemanager.webapp.address", "host2:2000");
        proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        TestAmFilterInitializer.assertEquals((int)1, (int)proxyHosts.size());
        Collections.sort(proxyHosts);
        TestAmFilterInitializer.assertEquals((String)"host2:2000", (String)((String)proxyHosts.get(0)));
        conf = new Configuration(false);
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2,rm3");
        conf.set("yarn.resourcemanager.webapp.address.rm1", "host2:2000");
        conf.set("yarn.resourcemanager.webapp.address.rm2", "host3:3000");
        conf.set("yarn.resourcemanager.webapp.address.rm3", "host4:4000");
        conf.set("yarn.resourcemanager.webapp.address.rm4", "dummy");
        conf.set("yarn.resourcemanager.webapp.https.address.rm1", "host5:5000");
        conf.set("yarn.resourcemanager.webapp.https.address.rm2", "host6:6000");
        proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        TestAmFilterInitializer.assertEquals((int)3, (int)proxyHosts.size());
        Collections.sort(proxyHosts);
        TestAmFilterInitializer.assertEquals((String)"host2:2000", (String)((String)proxyHosts.get(0)));
        TestAmFilterInitializer.assertEquals((String)"host3:3000", (String)((String)proxyHosts.get(1)));
        TestAmFilterInitializer.assertEquals((String)"host4:4000", (String)((String)proxyHosts.get(2)));
        conf = new Configuration(false);
        conf.set("yarn.http.policy", HttpConfig.Policy.HTTPS_ONLY.toString());
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2,rm3,dummy");
        conf.set("yarn.resourcemanager.webapp.address.rm1", "host2:2000");
        conf.set("yarn.resourcemanager.webapp.address.rm2", "host3:3000");
        conf.set("yarn.resourcemanager.webapp.address.rm3", "host4:4000");
        conf.set("yarn.resourcemanager.webapp.https.address.rm1", "host5:5000");
        conf.set("yarn.resourcemanager.webapp.https.address.rm2", "host6:6000");
        proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        TestAmFilterInitializer.assertEquals((int)2, (int)proxyHosts.size());
        Collections.sort(proxyHosts);
        TestAmFilterInitializer.assertEquals((String)"host5:5000", (String)((String)proxyHosts.get(0)));
        TestAmFilterInitializer.assertEquals((String)"host6:6000", (String)((String)proxyHosts.get(1)));
        conf = new Configuration(false);
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2,rm3");
        conf.set("yarn.resourcemanager.hostname.rm1", "host2");
        conf.set("yarn.resourcemanager.hostname.rm2", "host3");
        conf.set("yarn.resourcemanager.hostname.rm3", "host4");
        conf.set("yarn.resourcemanager.hostname.rm4", "dummy");
        proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        TestAmFilterInitializer.assertEquals((int)3, (int)proxyHosts.size());
        Collections.sort(proxyHosts);
        TestAmFilterInitializer.assertEquals((String)"host2:8088", (String)((String)proxyHosts.get(0)));
        TestAmFilterInitializer.assertEquals((String)"host3:8088", (String)((String)proxyHosts.get(1)));
        TestAmFilterInitializer.assertEquals((String)"host4:8088", (String)((String)proxyHosts.get(2)));
        conf = new Configuration(false);
        conf.set("yarn.http.policy", HttpConfig.Policy.HTTPS_ONLY.toString());
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2,rm3");
        conf.set("yarn.resourcemanager.hostname.rm1", "host2");
        conf.set("yarn.resourcemanager.hostname.rm2", "host3");
        conf.set("yarn.resourcemanager.hostname.rm3", "host4");
        conf.set("yarn.resourcemanager.hostname.rm4", "dummy");
        proxyHosts = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        TestAmFilterInitializer.assertEquals((int)3, (int)proxyHosts.size());
        Collections.sort(proxyHosts);
        TestAmFilterInitializer.assertEquals((String)"host2:8090", (String)((String)proxyHosts.get(0)));
        TestAmFilterInitializer.assertEquals((String)"host3:8090", (String)((String)proxyHosts.get(1)));
        TestAmFilterInitializer.assertEquals((String)"host4:8090", (String)((String)proxyHosts.get(2)));
    }

    class MockFilterContainer
    implements FilterContainer {
        Map<String, String> givenParameters;

        MockFilterContainer() {
        }

        public void addFilter(String name, String classname, Map<String, String> parameters) {
            this.givenParameters = parameters;
        }

        public void addGlobalFilter(String name, String classname, Map<String, String> parameters) {
        }
    }

    class MockAmFilterInitializer
    extends AmFilterInitializer {
        MockAmFilterInitializer() {
        }

        protected String getApplicationWebProxyBase() {
            return "/foo";
        }
    }
}

