/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy.amfilter;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.http.TestHttpServer;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpFilter;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpServletRequestWrapper;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.glassfish.grizzly.servlet.HttpServletResponseImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAmFilter {
    private String proxyHost = "localhost";
    private String proxyUri = "http://bogus";
    private String doFilterRequest;
    private AmIpServletRequestWrapper servletWrapper;

    @Test(timeout=5000L)
    public void filterNullCookies() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getCookies()).thenReturn(null);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)this.proxyHost);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        final AtomicBoolean invoked = new AtomicBoolean();
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                invoked.set(true);
            }
        };
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PROXY_HOST", this.proxyHost);
        params.put("PROXY_URI_BASE", this.proxyUri);
        DummyFilterConfig conf = new DummyFilterConfig(params);
        TestAmIpFilter filter = new TestAmIpFilter();
        filter.init(conf);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        Assert.assertTrue((boolean)invoked.get());
        filter.destroy();
    }

    @Test
    public void testFindRedirectUrl() throws Exception {
        String rm1 = "rm1";
        String rm2 = "rm2";
        String rm1Url = this.startHttpServer();
        String rm2Url = "host2:8088";
        TestAmIpFilter filter = new TestAmIpFilter();
        TestAmIpFilter spy = (TestAmIpFilter)((Object)Mockito.spy((Object)((Object)filter)));
        spy.proxyUriBases = new HashMap();
        spy.proxyUriBases.put("rm1", rm1Url);
        spy.proxyUriBases.put("rm2", "host2:8088");
        spy.rmUrls = new String[]{"rm1", "rm2"};
        Assertions.assertThat((String)spy.findRedirectUrl()).isEqualTo((Object)rm1Url);
    }

    private String startHttpServer() throws Exception {
        Server server = new Server(0);
        ((QueuedThreadPool)server.getThreadPool()).setMaxThreads(20);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/foo");
        server.setHandler((Handler)context);
        String servletPath = "/bar";
        context.addServlet(new ServletHolder(TestHttpServer.EchoServlet.class), servletPath);
        ((ServerConnector)server.getConnectors()[0]).setHost("localhost");
        server.start();
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        return server.getURI().toString() + servletPath;
    }

    @Test(timeout=2000L)
    public void testProxyUpdate() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PROXY_HOSTS", this.proxyHost);
        params.put("PROXY_URI_BASES", this.proxyUri);
        DummyFilterConfig conf = new DummyFilterConfig(params);
        final AmIpFilter filter = new AmIpFilter();
        int updateInterval = 1000;
        AmIpFilter.setUpdateInterval((long)updateInterval);
        filter.init((FilterConfig)conf);
        filter.getProxyAddresses();
        Assert.assertTrue((boolean)filter.getProxyAddresses().contains("127.0.0.1"));
        params = new HashMap();
        params.put("PROXY_HOSTS", "unknownhost");
        params.put("PROXY_URI_BASES", this.proxyUri);
        conf = new DummyFilterConfig(params);
        filter.init((FilterConfig)conf);
        Assert.assertFalse((boolean)filter.getProxyAddresses().isEmpty());
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    return filter.getProxyAddresses().isEmpty();
                }
                catch (ServletException e) {
                    return true;
                }
            }
        }, (long)500L, (long)updateInterval);
    }

    @Test(timeout=10000L)
    public void testFilter() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PROXY_HOST", this.proxyHost);
        params.put("PROXY_URI_BASE", this.proxyUri);
        DummyFilterConfig config = new DummyFilterConfig(params);
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                TestAmFilter.this.doFilterRequest = servletRequest.getClass().getName();
                if (servletRequest instanceof AmIpServletRequestWrapper) {
                    TestAmFilter.this.servletWrapper = (AmIpServletRequestWrapper)servletRequest;
                }
            }
        };
        AmIpFilter testFilter = new AmIpFilter();
        testFilter.init((FilterConfig)config);
        HttpServletResponseForTest response = new HttpServletResponseForTest();
        ServletRequest failRequest = (ServletRequest)Mockito.mock(ServletRequest.class);
        try {
            testFilter.doFilter(failRequest, (ServletResponse)response, chain);
            Assert.fail();
        }
        catch (ServletException e) {
            Assert.assertEquals((Object)"This filter only works for HTTP/HTTPS", (Object)e.getMessage());
        }
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"nowhere");
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)"/app/application_00_0");
        testFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        Assert.assertEquals((long)302L, (long)response.status);
        String redirect = response.getHeader("Location");
        Assert.assertEquals((Object)"http://bogus/app/application_00_0", (Object)redirect);
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)"/proxy/application_00_0");
        testFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        Assert.assertEquals((long)302L, (long)response.status);
        redirect = response.getHeader("Location");
        Assert.assertEquals((Object)"http://bogus/proxy/redirect/application_00_0", (Object)redirect);
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)"/proxy/application_00_0");
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)"id=0");
        testFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        Assert.assertEquals((long)302L, (long)response.status);
        redirect = response.getHeader("Location");
        Assert.assertEquals((Object)"http://bogus/proxy/redirect/application_00_0?id=0", (Object)redirect);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"127.0.0.1");
        testFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        Assert.assertTrue((boolean)this.doFilterRequest.contains("HttpServletRequest"));
        Cookie[] cookies = new Cookie[]{new Cookie("proxy-user", "user")};
        Mockito.when((Object)request.getCookies()).thenReturn((Object)cookies);
        testFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        Assert.assertEquals((Object)"org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpServletRequestWrapper", (Object)this.doFilterRequest);
        Assert.assertEquals((Object)"user", (Object)this.servletWrapper.getUserPrincipal().getName());
        Assert.assertEquals((Object)"user", (Object)this.servletWrapper.getRemoteUser());
        Assert.assertFalse((boolean)this.servletWrapper.isUserInRole(""));
    }

    private class HttpServletResponseForTest
    extends HttpServletResponseImpl {
        String redirectLocation = "";
        int status;
        private String contentType;
        private final Map<String, String> headers = new HashMap<String, String>(1);
        private StringWriter body;

        private HttpServletResponseForTest() {
        }

        public String getRedirect() {
            return this.redirectLocation;
        }

        public void sendRedirect(String location) throws IOException {
            this.redirectLocation = location;
        }

        public String encodeRedirectURL(String url) {
            return url;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public void setContentType(String type) {
            this.contentType = type;
        }

        public void setHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public String getHeader(String name) {
            return this.headers.get(name);
        }

        public PrintWriter getWriter() throws IOException {
            this.body = new StringWriter();
            return new PrintWriter(this.body);
        }
    }

    private static class DummyFilterConfig
    implements FilterConfig {
        final Map<String, String> map;

        DummyFilterConfig(Map<String, String> map) {
            this.map = map;
        }

        public String getFilterName() {
            return "dummy";
        }

        public String getInitParameter(String arg0) {
            return this.map.get(arg0);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(this.map.keySet());
        }

        public ServletContext getServletContext() {
            return null;
        }
    }

    private class TestAmIpFilter
    extends AmIpFilter {
        private Set<String> proxyAddresses = null;

        private TestAmIpFilter() {
        }

        protected Set<String> getProxyAddresses() {
            if (this.proxyAddresses == null) {
                this.proxyAddresses = new HashSet<String>();
            }
            this.proxyAddresses.add(TestAmFilter.this.proxyHost);
            return this.proxyAddresses;
        }
    }
}

