/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.thimbleware.jmemcached.Cache;
import com.thimbleware.jmemcached.CacheElement;
import com.thimbleware.jmemcached.CacheImpl;
import com.thimbleware.jmemcached.MemCacheDaemon;
import com.thimbleware.jmemcached.storage.CacheStorage;
import com.thimbleware.jmemcached.storage.hash.ConcurrentLinkedHashMap;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.io.hfile.CacheTestUtils;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.MemcachedBlockCache;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestMemcachedBlockCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMemcachedBlockCache.class);
    static MemCacheDaemon<? extends CacheElement> MEMCACHED;
    static MemcachedBlockCache CACHE;

    @Before
    public void before() throws Exception {
        MEMCACHED.getCache().flush_all();
        Assert.assertEquals((String)"Memcache is not empty", (long)MEMCACHED.getCache().getCurrentItems(), (long)0L);
    }

    @BeforeClass
    public static void setup() throws Exception {
        int port = HBaseTestingUtility.randomFreePort();
        MEMCACHED = TestMemcachedBlockCache.createDaemon(port);
        Configuration conf = new Configuration();
        conf.set("hbase.cache.memcached.servers", "localhost:" + port);
        CACHE = new MemcachedBlockCache(conf);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (MEMCACHED != null) {
            MEMCACHED.stop();
        }
    }

    @Test
    public void testCache() throws Exception {
        int NUM_BLOCKS = 10;
        CacheTestUtils.HFileBlockPair[] blocks = CacheTestUtils.generateHFileBlocks((int)65536, (int)10);
        for (int i = 0; i < 10; ++i) {
            CACHE.cacheBlock(blocks[i].getBlockName(), (Cacheable)blocks[i].getBlock());
        }
        Waiter.waitFor((Configuration)new Configuration(), (long)10000L, () -> MEMCACHED.getCache().getCurrentItems() == 10L);
    }

    @Test
    public void testEviction() throws Exception {
        int i;
        int NUM_BLOCKS = 10;
        CacheTestUtils.HFileBlockPair[] blocks = CacheTestUtils.generateHFileBlocks((int)65536, (int)10);
        for (i = 0; i < 10; ++i) {
            CACHE.cacheBlock(blocks[i].getBlockName(), (Cacheable)blocks[i].getBlock());
        }
        Waiter.waitFor((Configuration)new Configuration(), (long)10000L, () -> MEMCACHED.getCache().getCurrentItems() == 10L);
        for (i = 0; i < 10; ++i) {
            CACHE.evictBlock(blocks[i].getBlockName());
        }
        Waiter.waitFor((Configuration)new Configuration(), (long)10000L, () -> MEMCACHED.getCache().getCurrentItems() == 0L);
    }

    private static MemCacheDaemon<? extends CacheElement> createDaemon(int port) {
        InetSocketAddress addr = new InetSocketAddress("localhost", port);
        MemCacheDaemon daemon = new MemCacheDaemon();
        ConcurrentLinkedHashMap cacheStorage = ConcurrentLinkedHashMap.create((ConcurrentLinkedHashMap.EvictionPolicy)ConcurrentLinkedHashMap.EvictionPolicy.LRU, (int)1000, (long)0x100000L);
        daemon.setCache((Cache)new CacheImpl((CacheStorage)cacheStorage));
        daemon.setAddr(addr);
        daemon.setVerbose(true);
        daemon.start();
        while (!daemon.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return daemon;
    }
}

