/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ExportSnapshot;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowMapReduceTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
@Category(value={VerySlowMapReduceTests.class, LargeTests.class})
public class TestExportSnapshot {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestExportSnapshot.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestExportSnapshot.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    @Rule
    public final TestName testName = new TestName();
    protected TableName tableName;
    private byte[] emptySnapshotName;
    private byte[] snapshotName;
    private int tableNumFiles;
    private Admin admin;

    public static void setUpBaseConf(Configuration conf) {
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.setInt("hbase.regionserver.msginterval", 100);
        conf.setInt("mapreduce.job.maxtaskfailures.per.tracker", 100);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestExportSnapshot.setUpBaseConf(TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniMapReduceCluster();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = TEST_UTIL.getAdmin();
        this.tableName = TableName.valueOf((String)("testtb-" + this.testName.getMethodName()));
        this.snapshotName = Bytes.toBytes((String)("snaptb0-" + this.testName.getMethodName()));
        this.emptySnapshotName = Bytes.toBytes((String)("emptySnaptb0-" + this.testName.getMethodName()));
        this.createTable(this.tableName);
        this.admin.snapshot(this.emptySnapshotName, this.tableName);
        SnapshotTestingUtils.loadData((HBaseTestingUtility)TEST_UTIL, (TableName)this.tableName, (int)50, (byte[][])new byte[][]{FAMILY});
        this.tableNumFiles = this.admin.getTableRegions(this.tableName).size();
        this.admin.snapshot(this.snapshotName, this.tableName);
    }

    protected void createTable(TableName tableName) throws Exception {
        SnapshotTestingUtils.createPreSplitTable((HBaseTestingUtility)TEST_UTIL, (TableName)tableName, (int)2, (byte[][])new byte[][]{FAMILY});
    }

    protected RegionPredicate getBypassRegionPredicate() {
        return null;
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.deleteTable(this.tableName);
        SnapshotTestingUtils.deleteAllSnapshots((Admin)TEST_UTIL.getAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory((HBaseTestingUtility)TEST_UTIL);
    }

    @Test
    public void testExportFileSystemState() throws Exception {
        this.testExportFileSystemState(this.tableName, this.snapshotName, this.snapshotName, this.tableNumFiles);
    }

    @Test
    public void testExportFileSystemStateWithSkipTmp() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("snapshot.export.skip.tmp", true);
        try {
            this.testExportFileSystemState(this.tableName, this.snapshotName, this.snapshotName, this.tableNumFiles);
        }
        finally {
            TEST_UTIL.getConfiguration().setBoolean("snapshot.export.skip.tmp", false);
        }
    }

    @Test
    public void testEmptyExportFileSystemState() throws Exception {
        this.testExportFileSystemState(this.tableName, this.emptySnapshotName, this.emptySnapshotName, 0);
    }

    @Test
    public void testConsecutiveExports() throws Exception {
        Path copyDir = TestExportSnapshot.getLocalDestinationDir(TEST_UTIL);
        this.testExportFileSystemState(this.tableName, this.snapshotName, this.snapshotName, this.tableNumFiles, copyDir, false);
        this.testExportFileSystemState(this.tableName, this.snapshotName, this.snapshotName, this.tableNumFiles, copyDir, true);
        TestExportSnapshot.removeExportDir(copyDir);
    }

    @Test
    public void testExportWithTargetName() throws Exception {
        byte[] targetName = Bytes.toBytes((String)"testExportWithTargetName");
        this.testExportFileSystemState(this.tableName, this.snapshotName, targetName, this.tableNumFiles);
    }

    private void testExportFileSystemState(TableName tableName, byte[] snapshotName, byte[] targetName, int filesExpected) throws Exception {
        this.testExportFileSystemState(tableName, snapshotName, targetName, filesExpected, this.getHdfsDestinationDir(), false);
    }

    protected void testExportFileSystemState(TableName tableName, byte[] snapshotName, byte[] targetName, int filesExpected, Path copyDir, boolean overwrite) throws Exception {
        TestExportSnapshot.testExportFileSystemState(TEST_UTIL.getConfiguration(), tableName, snapshotName, targetName, filesExpected, TEST_UTIL.getDefaultRootDirPath(), copyDir, overwrite, this.getBypassRegionPredicate(), true);
    }

    protected static void testExportFileSystemState(Configuration conf, TableName tableName, byte[] snapshotName, byte[] targetName, int filesExpected, Path srcDir, Path rawTgtDir, boolean overwrite, RegionPredicate bypassregionPredicate, boolean success) throws Exception {
        FileSystem tgtFs = rawTgtDir.getFileSystem(conf);
        FileSystem srcFs = srcDir.getFileSystem(conf);
        Path tgtDir = rawTgtDir.makeQualified(tgtFs.getUri(), tgtFs.getWorkingDirectory());
        LOG.info("tgtFsUri={}, tgtDir={}, rawTgtDir={}, srcFsUri={}, srcDir={}", new Object[]{tgtFs.getUri(), tgtDir, rawTgtDir, srcFs.getUri(), srcDir});
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("--snapshot");
        opts.add(Bytes.toString((byte[])snapshotName));
        opts.add("--copy-to");
        opts.add(tgtDir.toString());
        if (targetName != snapshotName) {
            opts.add("--target");
            opts.add(Bytes.toString((byte[])targetName));
        }
        if (overwrite) {
            opts.add("--overwrite");
        }
        int res = ToolRunner.run((Configuration)conf, (Tool)new ExportSnapshot(), (String[])opts.toArray(new String[opts.size()]));
        Assert.assertEquals((String)("success " + success + ", res=" + res), (long)(success ? 0L : 1L), (long)res);
        if (!success) {
            Path targetDir = new Path(".hbase-snapshot", Bytes.toString((byte[])targetName));
            Assert.assertFalse((String)(tgtDir.toString() + " " + targetDir.toString()), (boolean)tgtFs.exists(new Path(tgtDir, targetDir)));
            return;
        }
        LOG.info("Exported snapshot");
        FileStatus[] rootFiles = tgtFs.listStatus(tgtDir);
        Assert.assertEquals((long)(filesExpected > 0 ? 2L : 1L), (long)rootFiles.length);
        for (FileStatus fileStatus : rootFiles) {
            String name = fileStatus.getPath().getName();
            Assert.assertTrue((String)fileStatus.toString(), (boolean)fileStatus.isDirectory());
            Assert.assertTrue((String)name.toString(), (name.equals(".hbase-snapshot") || name.equals("archive") ? 1 : 0) != 0);
        }
        LOG.info("Verified filesystem state");
        Path snapshotDir = new Path(".hbase-snapshot", Bytes.toString((byte[])snapshotName));
        Path targetDir = new Path(".hbase-snapshot", Bytes.toString((byte[])targetName));
        TestExportSnapshot.verifySnapshotDir(srcFs, new Path(srcDir, snapshotDir), tgtFs, new Path(tgtDir, targetDir));
        Set<String> snapshotFiles = TestExportSnapshot.verifySnapshot(conf, tgtFs, tgtDir, tableName, Bytes.toString((byte[])targetName), bypassregionPredicate);
        Assert.assertEquals((long)filesExpected, (long)snapshotFiles.size());
    }

    protected static void verifySnapshotDir(FileSystem fs1, Path root1, FileSystem fs2, Path root2) throws IOException {
        Assert.assertEquals(TestExportSnapshot.listFiles(fs1, root1, root1), TestExportSnapshot.listFiles(fs2, root2, root2));
    }

    protected static Set<String> verifySnapshot(Configuration conf, final FileSystem fs, Path rootDir, final TableName tableName, String snapshotName, final RegionPredicate bypassregionPredicate) throws IOException {
        Path exportedSnapshot = new Path(rootDir, new Path(".hbase-snapshot", snapshotName));
        final HashSet<String> snapshotFiles = new HashSet<String>();
        final Path exportedArchive = new Path(rootDir, "archive");
        SnapshotReferenceUtil.visitReferencedFiles((Configuration)conf, (FileSystem)fs, (Path)exportedSnapshot, (SnapshotReferenceUtil.SnapshotVisitor)new SnapshotReferenceUtil.SnapshotVisitor(){

            public void storeFile(RegionInfo regionInfo, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                if (bypassregionPredicate != null && bypassregionPredicate.evaluate(regionInfo)) {
                    return;
                }
                String hfile = storeFile.getName();
                snapshotFiles.add(hfile);
                if (!storeFile.hasReference()) {
                    this.verifyNonEmptyFile(new Path(exportedArchive, new Path(CommonFSUtils.getTableDir((Path)new Path("./"), (TableName)tableName), new Path(regionInfo.getEncodedName(), new Path(family, hfile)))));
                }
            }

            private void verifyNonEmptyFile(Path path) throws IOException {
                Assert.assertTrue((String)(path + " should exists"), (boolean)fs.exists(path));
                Assert.assertTrue((String)(path + " should not be empty"), (fs.getFileStatus(path).getLen() > 0L ? 1 : 0) != 0);
            }
        });
        SnapshotProtos.SnapshotDescription desc = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)fs, (Path)exportedSnapshot);
        Assert.assertTrue((boolean)desc.getName().equals(snapshotName));
        Assert.assertTrue((boolean)desc.getTable().equals(tableName.getNameAsString()));
        return snapshotFiles;
    }

    private static Set<String> listFiles(FileSystem fs, Path root, Path dir) throws IOException {
        HashSet<String> files = new HashSet<String>();
        LOG.debug("List files in {} in root {} at {}", new Object[]{fs, root, dir});
        int rootPrefix = root.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString().length();
        FileStatus[] list = CommonFSUtils.listStatus((FileSystem)fs, (Path)dir);
        if (list != null) {
            for (FileStatus fstat : list) {
                LOG.debug(Objects.toString(fstat.getPath()));
                if (fstat.isDirectory()) {
                    files.addAll(TestExportSnapshot.listFiles(fs, root, fstat.getPath()));
                    continue;
                }
                files.add(fstat.getPath().makeQualified(fs).toString().substring(rootPrefix));
            }
        }
        return files;
    }

    private Path getHdfsDestinationDir() {
        Path rootDir = TEST_UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        Path path = new Path(new Path(rootDir, "export-test"), "export-" + System.currentTimeMillis());
        LOG.info("HDFS export destination path: " + path);
        return path;
    }

    static Path getLocalDestinationDir(HBaseTestingUtility htu) {
        Path path = htu.getDataTestDir("local-export-" + System.currentTimeMillis());
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)htu.getConfiguration());
            LOG.info("Local export destination path: " + path);
            return path.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void removeExportDir(Path path) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)new Configuration());
        fs.delete(path, true);
    }

    protected static interface RegionPredicate {
        public boolean evaluate(RegionInfo var1);
    }
}

