/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.io.hfile.BloomFilterMetrics;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.regionserver.CreateStoreFileWriterParams;
import org.apache.hadoop.hbase.regionserver.DefaultStoreEngine;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class StoreEngine<SF extends StoreFlusher, CP extends CompactionPolicy, C extends Compactor<?>, SFM extends StoreFileManager> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreEngine.class);
    protected SF storeFlusher;
    protected CP compactionPolicy;
    protected C compactor;
    protected SFM storeFileManager;
    private final BloomFilterMetrics bloomFilterMetrics = new BloomFilterMetrics();
    private Configuration conf;
    private StoreContext ctx;
    private RegionCoprocessorHost coprocessorHost;
    private Function<String, ExecutorService> openStoreFileThreadPoolCreator;
    private StoreFileTracker storeFileTracker;
    private final ReadWriteLock storeLock = new ReentrantReadWriteLock();
    public static final String STORE_ENGINE_CLASS_KEY = "hbase.hstore.engine.class";
    private static final Class<? extends StoreEngine<?, ?, ?, ?>> DEFAULT_STORE_ENGINE_CLASS = DefaultStoreEngine.class;

    public void readLock() {
        this.storeLock.readLock().lock();
    }

    public void readUnlock() {
        this.storeLock.readLock().unlock();
    }

    public void writeLock() {
        this.storeLock.writeLock().lock();
    }

    public void writeUnlock() {
        this.storeLock.writeLock().unlock();
    }

    public CompactionPolicy getCompactionPolicy() {
        return this.compactionPolicy;
    }

    public Compactor<?> getCompactor() {
        return this.compactor;
    }

    public StoreFileManager getStoreFileManager() {
        return this.storeFileManager;
    }

    public StoreFlusher getStoreFlusher() {
        return this.storeFlusher;
    }

    private StoreFileTracker createStoreFileTracker(Configuration conf, HStore store) {
        return StoreFileTrackerFactory.create(conf, store.isPrimaryReplicaStore(), store.getStoreContext());
    }

    public abstract boolean needsCompaction(List<HStoreFile> var1);

    public abstract CompactionContext createCompaction() throws IOException;

    protected abstract void createComponents(Configuration var1, HStore var2, CellComparator var3) throws IOException;

    protected final void createComponentsOnce(Configuration conf, HStore store, CellComparator cellComparator) throws IOException {
        assert (this.compactor == null && this.compactionPolicy == null && this.storeFileManager == null && this.storeFlusher == null && this.storeFileTracker == null);
        this.createComponents(conf, store, cellComparator);
        this.conf = conf;
        this.ctx = store.getStoreContext();
        this.coprocessorHost = store.getHRegion().getCoprocessorHost();
        this.openStoreFileThreadPoolCreator = store.getHRegion()::getStoreFileOpenAndCloseThreadPool;
        this.storeFileTracker = this.createStoreFileTracker(conf, store);
        assert (this.compactor != null && this.compactionPolicy != null && this.storeFileManager != null && this.storeFlusher != null && this.storeFileTracker != null);
    }

    public StoreFileWriter createWriter(CreateStoreFileWriterParams params) throws IOException {
        return this.storeFileTracker.createWriter(params);
    }

    public HStoreFile createStoreFileAndReader(Path p) throws IOException {
        StoreFileInfo info = new StoreFileInfo(this.conf, this.ctx.getRegionFileSystem().getFileSystem(), p, this.ctx.isPrimaryReplicaStore());
        return this.createStoreFileAndReader(info);
    }

    public HStoreFile createStoreFileAndReader(StoreFileInfo info) throws IOException {
        info.setRegionCoprocessorHost(this.coprocessorHost);
        HStoreFile storeFile = new HStoreFile(info, this.ctx.getFamily().getBloomFilterType(), this.ctx.getCacheConf(), this.bloomFilterMetrics);
        storeFile.initReader();
        return storeFile;
    }

    public void validateStoreFile(Path path) throws IOException {
        HStoreFile storeFile = null;
        try {
            storeFile = this.createStoreFileAndReader(path);
        }
        catch (IOException e) {
            LOG.error("Failed to open store file : {}, keeping it in tmp location", (Object)path, (Object)e);
            throw e;
        }
        finally {
            if (storeFile != null) {
                storeFile.closeStoreFile(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HStoreFile> openStoreFiles(Collection<StoreFileInfo> files, boolean warmup) throws IOException {
        if (CollectionUtils.isEmpty(files)) {
            return Collections.emptyList();
        }
        ExecutorService storeFileOpenerThreadPool = this.openStoreFileThreadPoolCreator.apply("StoreFileOpener-" + this.ctx.getRegionInfo().getEncodedName() + "-" + this.ctx.getFamily().getNameAsString());
        ExecutorCompletionService<HStoreFile> completionService = new ExecutorCompletionService<HStoreFile>(storeFileOpenerThreadPool);
        int totalValidStoreFile = 0;
        for (StoreFileInfo storeFileInfo : files) {
            storeFileInfo.setConf(this.conf);
            completionService.submit(() -> this.createStoreFileAndReader(storeFileInfo));
            ++totalValidStoreFile;
        }
        HashSet<String> compactedStoreFiles = new HashSet<String>();
        ArrayList<HStoreFile> results = new ArrayList<HStoreFile>(files.size());
        IOException ioe = null;
        try {
            for (int i = 0; i < totalValidStoreFile; ++i) {
                try {
                    HStoreFile storeFile = (HStoreFile)completionService.take().get();
                    if (storeFile == null) continue;
                    LOG.debug("loaded {}", (Object)storeFile);
                    results.add(storeFile);
                    compactedStoreFiles.addAll(storeFile.getCompactedStoreFiles());
                    continue;
                }
                catch (InterruptedException e) {
                    if (ioe != null) continue;
                    ioe = new InterruptedIOException(e.getMessage());
                    continue;
                }
                catch (ExecutionException e) {
                    if (ioe != null) continue;
                    ioe = new IOException(e.getCause());
                }
            }
        }
        finally {
            storeFileOpenerThreadPool.shutdownNow();
        }
        if (ioe != null) {
            boolean evictOnClose = this.ctx.getCacheConf() != null ? this.ctx.getCacheConf().shouldEvictOnClose() : true;
            for (HStoreFile file : results) {
                try {
                    if (file == null) continue;
                    file.closeStoreFile(evictOnClose);
                }
                catch (IOException e) {
                    LOG.warn("Could not close store file {}", (Object)file, (Object)e);
                }
            }
            throw ioe;
        }
        if (!warmup) {
            ArrayList<HStoreFile> filesToRemove = new ArrayList<HStoreFile>(compactedStoreFiles.size());
            for (HStoreFile storeFile : results) {
                if (!compactedStoreFiles.contains(storeFile.getPath().getName())) continue;
                LOG.warn("Clearing the compacted storefile {} from {}", (Object)storeFile, (Object)this);
                storeFile.getReader().close(storeFile.getCacheConf() != null ? storeFile.getCacheConf().shouldEvictOnClose() : true);
                filesToRemove.add(storeFile);
            }
            results.removeAll(filesToRemove);
            if (!filesToRemove.isEmpty() && this.ctx.isPrimaryReplicaStore()) {
                LOG.debug("Moving the files {} to archive", filesToRemove);
                this.ctx.getRegionFileSystem().removeStoreFiles(this.ctx.getFamily().getNameAsString(), filesToRemove);
            }
        }
        return results;
    }

    public void initialize(boolean warmup) throws IOException {
        List<StoreFileInfo> fileInfos = this.storeFileTracker.load();
        List<HStoreFile> files = this.openStoreFiles(fileInfos, warmup);
        this.storeFileManager.loadFiles(files);
    }

    public void refreshStoreFiles() throws IOException {
        List<StoreFileInfo> fileInfos = this.storeFileTracker.load();
        this.refreshStoreFilesInternal(fileInfos);
    }

    public void refreshStoreFiles(Collection<String> newFiles) throws IOException {
        ArrayList<StoreFileInfo> storeFiles = new ArrayList<StoreFileInfo>(newFiles.size());
        for (String file : newFiles) {
            storeFiles.add(this.ctx.getRegionFileSystem().getStoreFileInfo(this.ctx.getFamily().getNameAsString(), file));
        }
        this.refreshStoreFilesInternal(storeFiles);
    }

    private void refreshStoreFilesInternal(Collection<StoreFileInfo> newFiles) throws IOException {
        Collection<HStoreFile> currentFiles = this.storeFileManager.getStorefiles();
        Collection<HStoreFile> compactedFiles = this.storeFileManager.getCompactedfiles();
        if (currentFiles == null) {
            currentFiles = Collections.emptySet();
        }
        if (newFiles == null) {
            newFiles = Collections.emptySet();
        }
        if (compactedFiles == null) {
            compactedFiles = Collections.emptySet();
        }
        HashMap<StoreFileInfo, HStoreFile> currentFilesSet = new HashMap<StoreFileInfo, HStoreFile>(currentFiles.size());
        for (HStoreFile hStoreFile : currentFiles) {
            currentFilesSet.put(hStoreFile.getFileInfo(), hStoreFile);
        }
        HashMap<StoreFileInfo, HStoreFile> compactedFilesSet = new HashMap<StoreFileInfo, HStoreFile>(compactedFiles.size());
        for (HStoreFile sf : compactedFiles) {
            compactedFilesSet.put(sf.getFileInfo(), sf);
        }
        HashSet<StoreFileInfo> hashSet = new HashSet<StoreFileInfo>(newFiles);
        Sets.SetView<StoreFileInfo> setView = Sets.difference(hashSet, compactedFilesSet.keySet());
        Sets.SetView<StoreFileInfo> toBeAddedFiles = Sets.difference(setView, currentFilesSet.keySet());
        Sets.SetView<StoreFileInfo> toBeRemovedFiles = Sets.difference(currentFilesSet.keySet(), setView);
        if (toBeAddedFiles.isEmpty() && toBeRemovedFiles.isEmpty()) {
            return;
        }
        LOG.info("Refreshing store files for " + this + " files to add: " + toBeAddedFiles + " files to remove: " + toBeRemovedFiles);
        HashSet<HStoreFile> toBeRemovedStoreFiles = new HashSet<HStoreFile>(toBeRemovedFiles.size());
        for (StoreFileInfo sfi : toBeRemovedFiles) {
            toBeRemovedStoreFiles.add((HStoreFile)currentFilesSet.get(sfi));
        }
        List<HStoreFile> openedFiles = this.openStoreFiles(toBeAddedFiles, false);
        this.replaceStoreFiles(toBeRemovedStoreFiles, openedFiles, () -> {}, () -> {});
    }

    public List<HStoreFile> commitStoreFiles(List<Path> files, boolean validate) throws IOException {
        ArrayList<HStoreFile> committedFiles = new ArrayList<HStoreFile>(files.size());
        HRegionFileSystem hfs = this.ctx.getRegionFileSystem();
        String familyName = this.ctx.getFamily().getNameAsString();
        Path storeDir = hfs.getStoreDir(familyName);
        for (Path file : files) {
            try {
                if (validate) {
                    this.validateStoreFile(file);
                }
                Path committedPath = file.getParent() != null && file.getParent().equals((Object)storeDir) ? file : hfs.commitStoreFile(familyName, file);
                HStoreFile sf = this.createStoreFileAndReader(committedPath);
                committedFiles.add(sf);
            }
            catch (IOException e) {
                LOG.error("Failed to commit store file {}", (Object)file, (Object)e);
                for (HStoreFile sf : committedFiles) {
                    Path pathToDelete = sf.getPath();
                    try {
                        sf.deleteStoreFile();
                    }
                    catch (IOException deleteEx) {
                        LOG.warn(HBaseMarkers.FATAL, "Failed to delete committed store file {}", (Object)pathToDelete, (Object)deleteEx);
                    }
                }
                throw new IOException("Failed to commit the flush", e);
            }
        }
        return committedFiles;
    }

    public void addStoreFiles(Collection<HStoreFile> storeFiles, IOExceptionRunnable actionAfterAdding) throws IOException {
        this.storeFileTracker.add(StoreUtils.toStoreFileInfo(storeFiles));
        this.writeLock();
        try {
            this.storeFileManager.insertNewFiles(storeFiles);
            actionAfterAdding.run();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceStoreFiles(Collection<HStoreFile> compactedFiles, Collection<HStoreFile> newFiles, IOExceptionRunnable walMarkerWriter, Runnable actionUnderLock) throws IOException {
        this.storeFileTracker.replace(StoreUtils.toStoreFileInfo(compactedFiles), StoreUtils.toStoreFileInfo(newFiles));
        walMarkerWriter.run();
        this.writeLock();
        try {
            this.storeFileManager.addCompactionResults(compactedFiles, newFiles);
            actionUnderLock.run();
        }
        finally {
            this.writeUnlock();
        }
    }

    public void removeCompactedFiles(Collection<HStoreFile> compactedFiles) {
        this.writeLock();
        try {
            this.storeFileManager.removeCompactedFiles(compactedFiles);
        }
        finally {
            this.writeUnlock();
        }
    }

    public static StoreEngine<?, ?, ?, ?> create(HStore store, Configuration conf, CellComparator cellComparator) throws IOException {
        String className = conf.get(STORE_ENGINE_CLASS_KEY, DEFAULT_STORE_ENGINE_CLASS.getName());
        try {
            StoreEngine se = (StoreEngine)ReflectionUtils.instantiateWithCustomCtor(className, new Class[0], new Object[0]);
            se.createComponentsOnce(conf, store, cellComparator);
            return se;
        }
        catch (Exception e) {
            throw new IOException("Unable to load configured store engine '" + className + "'", e);
        }
    }

    public boolean requireWritingToTmpDirFirst() {
        return this.storeFileTracker.requireWritingToTmpDirFirst();
    }

    @RestrictedApi(explanation="Should only be called in TestHStore", link="", allowedOnPath=".*/TestHStore.java")
    ReadWriteLock getLock() {
        return this.storeLock;
    }

    public BloomFilterMetrics getBloomFilterMetrics() {
        return this.bloomFilterMetrics;
    }

    @FunctionalInterface
    public static interface IOExceptionRunnable {
        public void run() throws IOException;
    }
}

