/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.hibernate.HibernateAccessStrategyAdapter;
import org.apache.ignite.cache.hibernate.HibernateCacheProxy;
import org.apache.ignite.cache.hibernate.HibernateExceptionConverter;
import org.jetbrains.annotations.Nullable;

public class HibernateTransactionalAccessStrategy
extends HibernateAccessStrategyAdapter {
    HibernateTransactionalAccessStrategy(Ignite ignite, HibernateCacheProxy cache, HibernateExceptionConverter eConverter) {
        super(ignite, cache, eConverter);
    }

    @Override
    @Nullable
    public Object get(Object key) {
        try {
            Object val = this.cache.get(key);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Get [cache=" + this.cache.name() + ", key=" + key + ", val=" + val + ']');
            }
            return val;
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    @Override
    public void putFromLoad(Object key, Object val) {
        try {
            this.cache.put(key, val);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Put [cache=" + this.cache.name() + ", key=" + key + ", val=" + val + ']');
            }
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    @Override
    public void lock(Object key) {
    }

    @Override
    public void unlock(Object key) {
    }

    @Override
    public boolean update(Object key, Object val) {
        try {
            boolean res = this.cache.put(key, val);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Update [cache=" + this.cache.name() + ", key=" + key + ", val=" + val + ", res=" + res + ']');
            }
            return res;
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    @Override
    public boolean afterUpdate(Object key, Object val) {
        return false;
    }

    @Override
    public boolean insert(Object key, Object val) {
        try {
            boolean res = this.cache.put(key, val);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Insert [cache=" + this.cache.name() + ", key=" + key + ", val=" + val + ", res=" + res + ']');
            }
            return res;
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }

    @Override
    public boolean afterInsert(Object key, Object val) {
        return false;
    }

    @Override
    public void remove(Object key) {
        try {
            this.cache.remove(key);
        }
        catch (IgniteCheckedException e) {
            throw this.convertException((Exception)((Object)e));
        }
    }
}

