/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.sql.engine.QueryCancelledException;
import org.apache.ignite.internal.util.Cancellable;
import org.apache.ignite.lang.IgniteException;

public class QueryCancel {
    private final List<Cancellable> cancelActions = new ArrayList<Cancellable>(3);
    private boolean canceled;

    public synchronized void add(Cancellable clo) throws QueryCancelledException {
        assert (clo != null);
        if (this.canceled) {
            throw new QueryCancelledException();
        }
        this.cancelActions.add(clo);
    }

    public synchronized void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        IgniteException ex = null;
        for (int i = this.cancelActions.size() - 1; i >= 0; --i) {
            try {
                Cancellable act = this.cancelActions.get(i);
                act.cancel();
                continue;
            }
            catch (Exception e) {
                if (ex == null) {
                    ex = new IgniteException((Throwable)e);
                    continue;
                }
                ex.addSuppressed((Throwable)e);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public synchronized void checkCancelled() throws QueryCancelledException {
        if (this.canceled) {
            throw new QueryCancelledException();
        }
    }

    public synchronized boolean isCanceled() {
        return this.canceled;
    }
}

