/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.manager.Event;
import org.apache.ignite.internal.manager.EventListener;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.sql.engine.SqlCursor;
import org.apache.ignite.internal.sql.engine.exec.ArrayRowHandler;
import org.apache.ignite.internal.sql.engine.exec.ExecutionService;
import org.apache.ignite.internal.sql.engine.exec.ExecutionServiceImpl;
import org.apache.ignite.internal.sql.engine.exec.QueryTaskExecutor;
import org.apache.ignite.internal.sql.engine.exec.QueryTaskExecutorImpl;
import org.apache.ignite.internal.sql.engine.extension.SqlExtension;
import org.apache.ignite.internal.sql.engine.message.MessageService;
import org.apache.ignite.internal.sql.engine.message.MessageServiceImpl;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlanCache;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlanCacheImpl;
import org.apache.ignite.internal.sql.engine.schema.SqlSchemaManagerImpl;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.table.event.TableEvent;
import org.apache.ignite.internal.table.event.TableEventParameters;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.NodeStoppingException;
import org.apache.ignite.network.ClusterService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQueryProcessor
implements QueryProcessor {
    public static final int PLAN_CACHE_SIZE = 1024;
    private final ClusterService clusterSrvc;
    private final TableManager tableManager;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final QueryPlanCache planCache = new QueryPlanCacheImpl(1024);
    private final List<Pair<TableEvent, EventListener<TableEventParameters>>> evtLsnrs = new ArrayList<Pair<TableEvent, EventListener<TableEventParameters>>>();
    private volatile ExecutionService executionSrvc;
    private volatile MessageService msgSrvc;
    private volatile QueryTaskExecutor taskExecutor;
    private volatile Map<String, SqlExtension> extensions;

    public SqlQueryProcessor(ClusterService clusterSrvc, TableManager tableManager) {
        this.clusterSrvc = clusterSrvc;
        this.tableManager = tableManager;
    }

    public void start() {
        this.taskExecutor = new QueryTaskExecutorImpl(this.clusterSrvc.localConfiguration().getName());
        this.msgSrvc = new MessageServiceImpl(this.clusterSrvc.topologyService(), this.clusterSrvc.messagingService(), this.taskExecutor);
        ArrayList extensionList = new ArrayList();
        ServiceLoader<SqlExtension> loader = ServiceLoader.load(SqlExtension.class);
        loader.reload();
        loader.forEach(extensionList::add);
        this.extensions = extensionList.stream().collect(Collectors.toMap(SqlExtension::name, Function.identity()));
        SqlSchemaManagerImpl schemaHolder = new SqlSchemaManagerImpl(this.tableManager, this.planCache::clear);
        this.executionSrvc = new ExecutionServiceImpl<Object[]>(this.clusterSrvc.topologyService(), this.msgSrvc, this.planCache, schemaHolder, this.tableManager, this.taskExecutor, ArrayRowHandler.INSTANCE, this.extensions);
        this.registerTableListener(TableEvent.CREATE, new TableCreatedListener(schemaHolder));
        this.registerTableListener(TableEvent.ALTER, new TableUpdatedListener(schemaHolder));
        this.registerTableListener(TableEvent.DROP, new TableDroppedListener(schemaHolder));
        this.taskExecutor.start();
        this.msgSrvc.start();
        this.executionSrvc.start();
        this.planCache.start();
        extensionList.forEach(ext -> ext.init(catalog -> schemaHolder.registerExternalCatalog(ext.name(), catalog)));
    }

    private void registerTableListener(TableEvent evt, AbstractTableEventListener lsnr) {
        this.evtLsnrs.add((Pair<TableEvent, EventListener<TableEventParameters>>)Pair.of((Object)evt, (Object)lsnr));
        this.tableManager.listen((Event)evt, (EventListener)lsnr);
    }

    public void stop() throws Exception {
        this.busyLock.block();
        ArrayList toClose = new ArrayList();
        Map<String, SqlExtension> extensions = this.extensions;
        if (extensions != null) {
            toClose.addAll(extensions.values().stream().map(ext -> ext::stop).collect(Collectors.toList()));
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[4];
        autoCloseableArray[0] = this.executionSrvc::stop;
        autoCloseableArray[1] = this.msgSrvc::stop;
        autoCloseableArray[2] = this.taskExecutor::stop;
        autoCloseableArray[3] = this.planCache::stop;
        Stream<AutoCloseable> closableComponents = Stream.of(autoCloseableArray);
        Stream<AutoCloseable> closableListeners = this.evtLsnrs.stream().map(p -> () -> this.tableManager.removeListener((Event)((TableEvent)p.left), (EventListener)p.right));
        toClose.addAll(Stream.concat(closableComponents, closableListeners).collect(Collectors.toList()));
        IgniteUtils.closeAll(toClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SqlCursor<List<?>>> query(String schemaName, String qry, Object ... params) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException((Throwable)new NodeStoppingException());
        }
        try {
            List<SqlCursor<List<?>>> list = this.executionSrvc.executeQuery(schemaName, qry, params);
            return list;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private static class TableDroppedListener
    extends AbstractTableEventListener {
        private TableDroppedListener(SqlSchemaManagerImpl schemaHolder) {
            super(schemaHolder);
        }

        public boolean notify(@NotNull TableEventParameters parameters, @Nullable Throwable exception) {
            this.schemaHolder.onTableDropped("PUBLIC", parameters.tableName());
            return false;
        }
    }

    private static class TableUpdatedListener
    extends AbstractTableEventListener {
        private TableUpdatedListener(SqlSchemaManagerImpl schemaHolder) {
            super(schemaHolder);
        }

        public boolean notify(@NotNull TableEventParameters parameters, @Nullable Throwable exception) {
            this.schemaHolder.onTableUpdated("PUBLIC", parameters.table());
            return false;
        }
    }

    private static class TableCreatedListener
    extends AbstractTableEventListener {
        private TableCreatedListener(SqlSchemaManagerImpl schemaHolder) {
            super(schemaHolder);
        }

        public boolean notify(@NotNull TableEventParameters parameters, @Nullable Throwable exception) {
            this.schemaHolder.onTableCreated("PUBLIC", parameters.table());
            return false;
        }
    }

    private static abstract class AbstractTableEventListener
    implements EventListener<TableEventParameters> {
        protected final SqlSchemaManagerImpl schemaHolder;

        private AbstractTableEventListener(SqlSchemaManagerImpl schemaHolder) {
            this.schemaHolder = schemaHolder;
        }

        public void remove(@NotNull Throwable exception) {
        }
    }
}

