/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.TreeIndex;
import org.apache.ignite.internal.sql.engine.util.FilteringIterator;
import org.apache.ignite.internal.sql.engine.util.TransformingIterator;
import org.apache.ignite.lang.IgniteInternalException;

public abstract class AbstractIndexScan<RowT, IdxRowT>
implements Iterable<RowT>,
AutoCloseable {
    private final TreeIndex<IdxRowT> idx;
    private final Predicate<RowT> filters;
    private final Supplier<RowT> lowerBound;
    private final Supplier<RowT> upperBound;
    private final Function<RowT, RowT> rowTransformer;
    protected final ExecutionContext<RowT> ectx;
    protected final RelDataType rowType;

    protected AbstractIndexScan(ExecutionContext<RowT> ectx, RelDataType rowType, TreeIndex<IdxRowT> idx, Predicate<RowT> filters, Supplier<RowT> lowerBound, Supplier<RowT> upperBound, Function<RowT, RowT> rowTransformer) {
        this.ectx = ectx;
        this.rowType = rowType;
        this.idx = idx;
        this.filters = filters;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.rowTransformer = rowTransformer;
    }

    @Override
    public synchronized Iterator<RowT> iterator() {
        Object lower = this.lowerBound == null ? null : (Object)this.row2indexRow(this.lowerBound.get());
        Object upper = this.upperBound == null ? null : (Object)this.row2indexRow(this.upperBound.get());
        Iterator<Object> it = new TransformingIterator<Object, Object>((Iterator<Object>)this.idx.find(lower, upper), this::indexRow2Row);
        it = new FilteringIterator<RowT>(it, this.filters);
        if (this.rowTransformer != null) {
            it = new TransformingIterator<RowT, RowT>(it, this.rowTransformer);
        }
        return it;
    }

    protected abstract IdxRowT row2indexRow(RowT var1);

    protected abstract RowT indexRow2Row(IdxRowT var1) throws IgniteInternalException;

    @Override
    public void close() {
    }
}

