/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.ignite.internal.sql.engine.exec.QueryTaskExecutor;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.ExpressionFactory;
import org.apache.ignite.internal.sql.engine.exec.exp.ExpressionFactoryImpl;
import org.apache.ignite.internal.sql.engine.extension.SqlExtension;
import org.apache.ignite.internal.sql.engine.metadata.ColocationGroup;
import org.apache.ignite.internal.sql.engine.metadata.FragmentDescription;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.AbstractQueryContext;
import org.apache.ignite.internal.sql.engine.util.BaseQueryContext;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.lang.IgniteInternalException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionContext<RowT>
extends AbstractQueryContext
implements DataContext {
    private static final TimeZone TIME_ZONE = TimeZone.getDefault();
    private static final Locale LOCALE = Locale.ENGLISH;
    private final BaseQueryContext qctx;
    private final QueryTaskExecutor executor;
    private final UUID qryId;
    private final FragmentDescription fragmentDesc;
    private final Map<String, Object> params;
    private final String locNodeId;
    private final String originatingNodeId;
    private final long topVer;
    private final RowHandler<RowT> handler;
    private final ExpressionFactory<RowT> expressionFactory;
    private final AtomicBoolean cancelFlag = new AtomicBoolean();
    private final long startTs;
    private Object[] correlations = new Object[16];

    public ExecutionContext(BaseQueryContext qctx, QueryTaskExecutor executor, UUID qryId, String locNodeId, String originatingNodeId, long topVer, FragmentDescription fragmentDesc, RowHandler<RowT> handler, Map<String, Object> params) {
        super(qctx);
        this.executor = executor;
        this.qctx = qctx;
        this.qryId = qryId;
        this.fragmentDesc = fragmentDesc;
        this.handler = handler;
        this.params = params;
        this.locNodeId = locNodeId;
        this.originatingNodeId = originatingNodeId;
        this.topVer = topVer;
        this.expressionFactory = new ExpressionFactoryImpl(this, this.qctx.typeFactory(), this.qctx.config().getParserConfig().conformance());
        long ts = System.currentTimeMillis();
        this.startTs = ts + (long)TIME_ZONE.getOffset(ts);
    }

    public UUID queryId() {
        return this.qryId;
    }

    public long fragmentId() {
        return this.fragmentDesc.fragmentId();
    }

    public ColocationGroup target() {
        return this.fragmentDesc.target();
    }

    public List<String> remotes(long exchangeId) {
        return (List)this.fragmentDesc.remotes().get(exchangeId);
    }

    public ColocationGroup group(long sourceId) {
        return this.fragmentDesc.mapping().findGroup(sourceId);
    }

    public boolean keepBinary() {
        return true;
    }

    public RowHandler<RowT> rowHandler() {
        return this.handler;
    }

    public ExpressionFactory<RowT> expressionFactory() {
        return this.expressionFactory;
    }

    public String originatingNodeId() {
        return this.originatingNodeId;
    }

    public String localNodeId() {
        return this.locNodeId;
    }

    public long topologyVersion() {
        return this.topVer;
    }

    @Nullable
    public SqlExtension extension(String name) {
        return this.qctx.extension(name);
    }

    public SchemaPlus getRootSchema() {
        return this.qctx.schema();
    }

    public IgniteTypeFactory getTypeFactory() {
        return this.qctx.typeFactory();
    }

    public QueryProvider getQueryProvider() {
        return null;
    }

    public Object get(String name) {
        if (DataContext.Variable.CANCEL_FLAG.camelName.equals(name)) {
            return this.cancelFlag;
        }
        if (DataContext.Variable.TIME_ZONE.camelName.equals(name)) {
            return TIME_ZONE;
        }
        if (DataContext.Variable.CURRENT_TIMESTAMP.camelName.equals(name)) {
            return this.startTs;
        }
        if (DataContext.Variable.LOCAL_TIMESTAMP.camelName.equals(name)) {
            return this.startTs;
        }
        if (DataContext.Variable.LOCALE.camelName.equals(name)) {
            return LOCALE;
        }
        if (name.startsWith("?")) {
            return TypeUtils.toInternal(this, this.params.get(name));
        }
        return this.params.get(name);
    }

    @NotNull
    public Object getCorrelated(int id) {
        Commons.checkRange(this.correlations, id);
        return this.correlations[id];
    }

    public void setCorrelated(@NotNull Object value, int id) {
        this.correlations = Commons.ensureCapacity(this.correlations, id + 1);
        this.correlations[id] = value;
    }

    public void execute(RunnableX task, Consumer<Throwable> onError) {
        if (this.isCancelled()) {
            return;
        }
        this.executor.execute(this.qryId, this.fragmentId(), () -> {
            try {
                task.run();
            }
            catch (Throwable e) {
                onError.accept(e);
                throw new IgniteInternalException("Unexpected exception", e);
            }
        });
    }

    public CompletableFuture<?> submit(RunnableX task, Consumer<Throwable> onError) {
        assert (!this.isCancelled()) : "Call submit after execution was cancelled.";
        return this.executor.submit(this.qryId, this.fragmentId(), () -> {
            try {
                task.run();
            }
            catch (Throwable e) {
                onError.accept(e);
                throw new IgniteInternalException("Unexpected exception", e);
            }
        });
    }

    public boolean cancel() {
        return !this.cancelFlag.get() && this.cancelFlag.compareAndSet(false, true);
    }

    public boolean isCancelled() {
        return this.cancelFlag.get();
    }

    @FunctionalInterface
    public static interface RunnableX {
        public void run() throws Throwable;
    }
}

