/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.internal.sql.engine.exec.MailboxRegistry;
import org.apache.ignite.internal.sql.engine.exec.rel.Inbox;
import org.apache.ignite.internal.sql.engine.exec.rel.Mailbox;
import org.apache.ignite.internal.sql.engine.exec.rel.Outbox;
import org.apache.ignite.internal.sql.engine.util.NodeLeaveHandler;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.TopologyEventHandler;
import org.apache.ignite.network.TopologyService;
import org.jetbrains.annotations.Nullable;

public class MailboxRegistryImpl
implements MailboxRegistry {
    private static final Predicate<Mailbox<?>> ALWAYS_TRUE = o -> true;
    private final TopologyService topSrvc;
    private final Map<MailboxKey, Outbox<?>> locals;
    private final Map<MailboxKey, Inbox<?>> remotes;

    public MailboxRegistryImpl(TopologyService topSrvc) {
        this.topSrvc = topSrvc;
        this.locals = new ConcurrentHashMap();
        this.remotes = new ConcurrentHashMap();
    }

    @Override
    public void start() {
        this.topSrvc.addEventHandler((TopologyEventHandler)new NodeLeaveHandler(this::onNodeLeft));
    }

    @Override
    public <T> Inbox<T> register(Inbox<T> inbox) {
        Inbox<T> old = this.remotes.putIfAbsent(new MailboxKey(inbox.queryId(), inbox.exchangeId()), inbox);
        return old != null ? old : inbox;
    }

    @Override
    public void register(Outbox<?> outbox) {
        Outbox<?> res = this.locals.put(new MailboxKey(outbox.queryId(), outbox.exchangeId()), outbox);
        assert (res == null) : res;
    }

    @Override
    public void unregister(Inbox<?> inbox) {
        this.remotes.remove(new MailboxKey(inbox.queryId(), inbox.exchangeId()), inbox);
    }

    @Override
    public void unregister(Outbox<?> outbox) {
        this.locals.remove(new MailboxKey(outbox.queryId(), outbox.exchangeId()), outbox);
    }

    @Override
    public Outbox<?> outbox(UUID qryId, long exchangeId) {
        return this.locals.get(new MailboxKey(qryId, exchangeId));
    }

    @Override
    public Inbox<?> inbox(UUID qryId, long exchangeId) {
        return this.remotes.get(new MailboxKey(qryId, exchangeId));
    }

    @Override
    public Collection<Inbox<?>> inboxes(@Nullable UUID qryId, long fragmentId, long exchangeId) {
        return this.remotes.values().stream().filter(MailboxRegistryImpl.makeFilter(qryId, fragmentId, exchangeId)).collect(Collectors.toList());
    }

    @Override
    public Collection<Outbox<?>> outboxes(@Nullable UUID qryId, long fragmentId, long exchangeId) {
        return this.locals.values().stream().filter(MailboxRegistryImpl.makeFilter(qryId, fragmentId, exchangeId)).collect(Collectors.toList());
    }

    private void onNodeLeft(ClusterNode node) {
        this.locals.values().forEach(n -> n.onNodeLeft(node.id()));
        this.remotes.values().forEach(n -> n.onNodeLeft(node.id()));
    }

    private static Predicate<Mailbox<?>> makeFilter(@Nullable UUID qryId, long fragmentId, long exchangeId) {
        Predicate<Mailbox<?>> filter = ALWAYS_TRUE;
        if (qryId != null) {
            filter = filter.and(mailbox -> Objects.equals(mailbox.queryId(), qryId));
        }
        if (fragmentId != -1L) {
            filter = filter.and(mailbox -> mailbox.fragmentId() == fragmentId);
        }
        if (exchangeId != -1L) {
            filter = filter.and(mailbox -> mailbox.exchangeId() == exchangeId);
        }
        return filter;
    }

    public String toString() {
        return S.toString(MailboxRegistryImpl.class, (Object)this);
    }

    @Override
    public void stop() {
        this.locals.clear();
        this.remotes.clear();
    }

    private static class MailboxKey {
        private final UUID qryId;
        private final long exchangeId;

        private MailboxKey(UUID qryId, long exchangeId) {
            this.qryId = qryId;
            this.exchangeId = exchangeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MailboxKey that = (MailboxKey)o;
            if (this.exchangeId != that.exchangeId) {
                return false;
            }
            return this.qryId.equals(that.qryId);
        }

        public int hashCode() {
            int res = this.qryId.hashCode();
            res = 31 * res + (int)(this.exchangeId ^ this.exchangeId >>> 32);
            return res;
        }

        public String toString() {
            return S.toString(MailboxKey.class, (Object)this);
        }
    }
}

