/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RuntimeIndex;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.GroupKey;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class RuntimeHashIndex<RowT>
implements RuntimeIndex<RowT> {
    protected final ExecutionContext<RowT> ectx;
    private final ImmutableBitSet keys;
    private HashMap<GroupKey, List<RowT>> rows;

    public RuntimeHashIndex(ExecutionContext<RowT> ectx, ImmutableBitSet keys) {
        this.ectx = ectx;
        assert (!CollectionUtils.nullOrEmpty((Iterable)keys));
        this.keys = keys;
        this.rows = new HashMap();
    }

    @Override
    public void push(RowT r) {
        List eqRows = this.rows.computeIfAbsent(this.key(r), k -> new ArrayList());
        eqRows.add(r);
    }

    @Override
    public void close() {
        this.rows.clear();
    }

    public Iterable<RowT> scan(Supplier<RowT> searchRow) {
        return new IndexScan(searchRow);
    }

    private GroupKey key(RowT r) {
        GroupKey.Builder b = GroupKey.builder(this.keys.cardinality());
        for (Integer field : this.keys) {
            b.add(this.ectx.rowHandler().get(field, r));
        }
        return b.build();
    }

    private class IndexScan
    implements Iterable<RowT>,
    AutoCloseable {
        private final Supplier<RowT> searchRow;

        IndexScan(Supplier<RowT> searchRow) {
            this.searchRow = searchRow;
        }

        @Override
        public void close() {
        }

        @Override
        @NotNull
        public Iterator<RowT> iterator() {
            List eqRows = RuntimeHashIndex.this.rows.get(RuntimeHashIndex.this.key(this.searchRow.get()));
            return eqRows == null ? Collections.emptyIterator() : eqRows.iterator();
        }
    }
}

