/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.ddl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.schemas.table.ColumnChange;
import org.apache.ignite.configuration.schemas.table.ColumnView;
import org.apache.ignite.configuration.schemas.table.PrimaryKeyView;
import org.apache.ignite.configuration.schemas.table.TableChange;
import org.apache.ignite.configuration.schemas.table.TableIndexChange;
import org.apache.ignite.internal.schema.configuration.SchemaConfigurationConverter;
import org.apache.ignite.internal.schema.definition.TableDefinitionImpl;
import org.apache.ignite.internal.sql.engine.prepare.PlanningContext;
import org.apache.ignite.internal.sql.engine.prepare.ddl.AbstractTableDdlCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.AlterTableAddCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.AlterTableDropCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.CreateIndexCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.CreateTableCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DdlCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DropIndexCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DropTableCommand;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteObjectName;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.Pair;
import org.apache.ignite.lang.ColumnAlreadyExistsException;
import org.apache.ignite.lang.ColumnNotFoundException;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.lang.IndexAlreadyExistsException;
import org.apache.ignite.lang.TableAlreadyExistsException;
import org.apache.ignite.lang.TableNotFoundException;
import org.apache.ignite.schema.SchemaBuilders;
import org.apache.ignite.schema.definition.ColumnDefinition;
import org.apache.ignite.schema.definition.ColumnType;
import org.apache.ignite.schema.definition.TableDefinition;
import org.apache.ignite.schema.definition.builder.ColumnDefinitionBuilder;
import org.apache.ignite.schema.definition.builder.PrimaryKeyDefinitionBuilder;
import org.apache.ignite.schema.definition.builder.SortedIndexDefinitionBuilder;
import org.apache.ignite.schema.definition.index.IndexDefinition;

public class DdlCommandHandler {
    private final TableManager tableManager;
    private PlanningContext pctx;

    public DdlCommandHandler(TableManager tblManager) {
        this.tableManager = tblManager;
    }

    public void handle(DdlCommand cmd, PlanningContext pctx) throws IgniteInternalCheckedException {
        this.validateCommand(cmd);
        this.pctx = pctx;
        if (cmd instanceof CreateTableCommand) {
            this.handleCreateTable((CreateTableCommand)cmd);
        } else if (cmd instanceof DropTableCommand) {
            this.handleDropTable((DropTableCommand)cmd);
        } else if (cmd instanceof AlterTableAddCommand) {
            this.handleAlterAddColumn((AlterTableAddCommand)cmd);
        } else if (cmd instanceof AlterTableDropCommand) {
            this.handleAlterDropColumn((AlterTableDropCommand)cmd);
        } else if (cmd instanceof CreateIndexCommand) {
            this.handleCreateIndex((CreateIndexCommand)cmd);
        } else if (cmd instanceof DropIndexCommand) {
            this.handleDropIndex((DropIndexCommand)cmd);
        } else {
            throw new IgniteInternalCheckedException("Unsupported DDL operation [cmdName=" + (cmd == null ? null : cmd.getClass().getSimpleName()) + "; querySql=\"" + pctx.query() + "\"]");
        }
    }

    private void validateCommand(DdlCommand cmd) {
        AbstractTableDdlCommand cmd0;
        if (cmd instanceof AbstractTableDdlCommand && IgniteUtils.nullOrEmpty((String)(cmd0 = (AbstractTableDdlCommand)cmd).tableName())) {
            throw new IllegalArgumentException("Table name is undefined.");
        }
    }

    private void handleCreateTable(CreateTableCommand cmd) {
        block3: {
            PrimaryKeyDefinitionBuilder pkeyDef = SchemaBuilders.primaryKey();
            pkeyDef.withColumns(IgniteObjectName.quoteNames(cmd.primaryKeyColumns()));
            pkeyDef.withAffinityColumns(IgniteObjectName.quoteNames(cmd.affColumns()));
            IgniteTypeFactory typeFactory = this.pctx.typeFactory();
            ArrayList<ColumnDefinition> colsInner = new ArrayList<ColumnDefinition>();
            for (org.apache.ignite.internal.sql.engine.prepare.ddl.ColumnDefinition col : cmd.columns()) {
                ColumnDefinitionBuilder col0 = SchemaBuilders.column((String)IgniteObjectName.quote((String)col.name()), (ColumnType)typeFactory.columnType(col.type())).asNullable(col.nullable()).withDefaultValueExpression(col.defaultValue());
                colsInner.add(col0.build());
            }
            Consumer<TableChange> tblChanger = tblCh -> {
                TableChange conv = SchemaConfigurationConverter.convert((TableDefinition)SchemaBuilders.tableBuilder((String)IgniteObjectName.quote((String)cmd.schemaName()), (String)IgniteObjectName.quote((String)cmd.tableName())).columns(colsInner).withPrimaryKey(pkeyDef.build()).build(), (TableChange)tblCh);
                if (cmd.partitions() != null) {
                    conv.changePartitions(cmd.partitions().intValue());
                }
                if (cmd.replicas() != null) {
                    conv.changeReplicas(cmd.replicas().intValue());
                }
            };
            String fullName = TableDefinitionImpl.canonicalName((String)IgniteObjectName.quote((String)cmd.schemaName()), (String)IgniteObjectName.quote((String)cmd.tableName()));
            try {
                this.tableManager.createTable(fullName, tblChanger);
            }
            catch (TableAlreadyExistsException ex) {
                if (cmd.ifTableExists()) break block3;
                throw ex;
            }
        }
    }

    private void handleDropTable(DropTableCommand cmd) {
        block2: {
            String fullName = TableDefinitionImpl.canonicalName((String)IgniteObjectName.quote((String)cmd.schemaName()), (String)IgniteObjectName.quote((String)cmd.tableName()));
            try {
                this.tableManager.dropTable(fullName);
            }
            catch (TableNotFoundException ex) {
                if (cmd.ifTableExists()) break block2;
                throw ex;
            }
        }
    }

    private void handleAlterAddColumn(AlterTableAddCommand cmd) {
        block3: {
            if (CollectionUtils.nullOrEmpty(cmd.columns())) {
                return;
            }
            String fullName = TableDefinitionImpl.canonicalName((String)IgniteObjectName.quote((String)cmd.schemaName()), (String)IgniteObjectName.quote((String)cmd.tableName()));
            try {
                this.addColumnInternal(fullName, cmd.columns(), cmd.ifColumnNotExists());
            }
            catch (TableNotFoundException ex) {
                if (cmd.ifTableExists()) break block3;
                throw ex;
            }
        }
    }

    private void handleAlterDropColumn(AlterTableDropCommand cmd) {
        block3: {
            if (CollectionUtils.nullOrEmpty(cmd.columns())) {
                return;
            }
            String fullName = TableDefinitionImpl.canonicalName((String)IgniteObjectName.quote((String)cmd.schemaName()), (String)IgniteObjectName.quote((String)cmd.tableName()));
            try {
                this.dropColumnInternal(fullName, cmd.columns(), cmd.ifColumnExists());
            }
            catch (TableNotFoundException ex) {
                if (cmd.ifTableExists()) break block3;
                throw ex;
            }
        }
    }

    private void handleCreateIndex(CreateIndexCommand cmd) {
        SortedIndexDefinitionBuilder idx = SchemaBuilders.sortedIndex((String)cmd.indexName());
        for (Pair<String, Boolean> idxInfo : cmd.columns()) {
            SortedIndexDefinitionBuilder.SortedIndexColumnBuilder idx0 = idx.addIndexColumn((String)idxInfo.getFirst());
            if (((Boolean)idxInfo.getSecond()).booleanValue()) {
                idx0.desc();
            }
            idx0.done();
        }
        String fullName = TableDefinitionImpl.canonicalName((String)IgniteObjectName.quote((String)cmd.schemaName()), (String)IgniteObjectName.quote((String)cmd.tableName()));
        this.tableManager.alterTable(fullName, chng -> chng.changeIndices(idxes -> {
            if (idxes.get(cmd.indexName()) != null) {
                if (!cmd.ifIndexNotExists()) {
                    throw new IndexAlreadyExistsException(cmd.indexName());
                }
                return;
            }
            idxes.create(cmd.indexName(), tableIndexChange -> SchemaConfigurationConverter.convert((IndexDefinition)idx.build(), (TableIndexChange)tableIndexChange));
        }));
    }

    private void handleDropIndex(DropIndexCommand cmd) {
        throw new UnsupportedOperationException("DROP INDEX command not supported for now.");
    }

    private void addColumnInternal(String fullName, List<org.apache.ignite.internal.sql.engine.prepare.ddl.ColumnDefinition> colsDef, boolean colNotExist) {
        this.tableManager.alterTable(fullName, chng -> chng.changeColumns(cols -> {
            List colsDef0;
            Map<String, String> colNamesToOrders = DdlCommandHandler.columnOrdersToNames((NamedListView<? extends ColumnView>)chng.columns());
            if (!colNotExist) {
                colsDef.stream().filter(k -> colNamesToOrders.containsKey(k.name())).findAny().ifPresent(c -> {
                    throw new ColumnAlreadyExistsException(c.name());
                });
                colsDef0 = colsDef;
            } else {
                colsDef0 = colsDef.stream().filter(k -> !colNamesToOrders.containsKey(k.name())).collect(Collectors.toList());
            }
            IgniteTypeFactory typeFactory = this.pctx.typeFactory();
            for (org.apache.ignite.internal.sql.engine.prepare.ddl.ColumnDefinition col : colsDef0) {
                ColumnDefinitionBuilder col0 = SchemaBuilders.column((String)IgniteObjectName.quote((String)col.name()), (ColumnType)typeFactory.columnType(col.type())).asNullable(col.nullable()).withDefaultValueExpression(col.defaultValue());
                cols.create(col.name(), colChg -> SchemaConfigurationConverter.convert((ColumnDefinition)col0.build(), (ColumnChange)colChg));
            }
        }));
    }

    private void dropColumnInternal(String fullName, Set<String> colNames, boolean colExist) {
        this.tableManager.alterTable(fullName, chng -> chng.changeColumns(cols -> {
            PrimaryKeyView priKey = chng.primaryKey();
            Map<String, String> colNamesToOrders = DdlCommandHandler.columnOrdersToNames((NamedListView<? extends ColumnView>)chng.columns());
            HashSet<String> colNames0 = new HashSet<String>();
            Set<String> primaryCols = Set.of(priKey.columns());
            for (String colName : colNames) {
                if (!colNamesToOrders.containsKey(colName)) {
                    if (!colExist) {
                        throw new ColumnNotFoundException(colName, fullName);
                    }
                } else {
                    colNames0.add(colName);
                }
                if (!primaryCols.contains(colName)) continue;
                throw new IgniteException(IgniteStringFormatter.format((String)"Can`t delete column, belongs to primary key: [name={}]", (Object[])new Object[]{colName}));
            }
            colNames0.forEach(k -> cols.delete((String)colNamesToOrders.get(k)));
        }));
    }

    private static Map<String, String> columnOrdersToNames(NamedListView<? extends ColumnView> cols) {
        HashMap<String, String> colNames = new HashMap<String, String>(cols.size());
        for (String colOrder : cols.namedListKeys()) {
            colNames.put(((ColumnView)cols.get(colOrder)).name(), colOrder);
        }
        return colNames;
    }
}

