/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.BiScalar;
import org.apache.ignite.internal.sql.engine.exec.exp.ExpressionFactory;
import org.apache.ignite.internal.sql.engine.exec.exp.RexToLixTranslator;
import org.apache.ignite.internal.sql.engine.exec.exp.Scalar;
import org.apache.ignite.internal.sql.engine.exec.exp.SingleScalar;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorWrapper;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorsFactory;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.IgniteMethod;
import org.apache.ignite.internal.sql.engine.util.Primitives;
import org.apache.ignite.internal.util.CollectionUtils;

public class ExpressionFactoryImpl<RowT>
implements ExpressionFactory<RowT> {
    private static final int CACHE_SIZE = 1024;
    private static final ConcurrentMap<String, Scalar> SCALAR_CACHE = Caffeine.newBuilder().maximumSize(1024L).build().asMap();
    private final IgniteTypeFactory typeFactory;
    private final SqlConformance conformance;
    private final RexBuilder rexBuilder;
    private final RelDataType emptyType;
    private final ExecutionContext<RowT> ctx;

    public ExpressionFactoryImpl(ExecutionContext<RowT> ctx, IgniteTypeFactory typeFactory, SqlConformance conformance) {
        this.ctx = ctx;
        this.typeFactory = typeFactory;
        this.conformance = conformance;
        this.rexBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory);
        this.emptyType = new RelDataTypeFactory.Builder((RelDataTypeFactory)this.typeFactory).build();
    }

    @Override
    public Supplier<List<AccumulatorWrapper<RowT>>> accumulatorsFactory(AggregateType type, List<AggregateCall> calls, RelDataType rowType) {
        if (calls.isEmpty()) {
            return null;
        }
        return new AccumulatorsFactory<RowT>(this.ctx, type, calls, rowType);
    }

    @Override
    public Comparator<RowT> comparator(RelCollation collation) {
        if (collation == null || collation.getFieldCollations().isEmpty()) {
            return null;
        }
        if (collation.getFieldCollations().size() == 1) {
            return this.comparator((RelFieldCollation)collation.getFieldCollations().get(0));
        }
        return Commons.compoundComparator(collation.getFieldCollations().stream().map(this::comparator).collect(Collectors.toList()));
    }

    @Override
    public Comparator<RowT> comparator(List<RelFieldCollation> left, List<RelFieldCollation> right) {
        if (CollectionUtils.nullOrEmpty(left) || CollectionUtils.nullOrEmpty(right) || left.size() != right.size()) {
            throw new IllegalArgumentException("Both inputs should be non-empty and have the same size: left=" + (Serializable)(left != null ? Integer.valueOf(left.size()) : "null") + ", right=" + (Serializable)(right != null ? Integer.valueOf(right.size()) : "null"));
        }
        ArrayList comparators = new ArrayList();
        for (int i = 0; i < left.size(); ++i) {
            comparators.add(this.comparator(left.get(i), right.get(i)));
        }
        return Commons.compoundComparator(comparators);
    }

    private Comparator<RowT> comparator(RelFieldCollation fieldCollation) {
        int nullComparison = fieldCollation.nullDirection.nullComparison;
        int x = fieldCollation.getFieldIndex();
        RowHandler handler = this.ctx.rowHandler();
        if (fieldCollation.direction == RelFieldCollation.Direction.ASCENDING) {
            return (o1, o2) -> {
                Comparable c1 = (Comparable)handler.get(x, o1);
                Comparable c2 = (Comparable)handler.get(x, o2);
                return RelFieldCollation.compare((Comparable)c1, (Comparable)c2, (int)nullComparison);
            };
        }
        return (o1, o2) -> {
            Comparable c1 = (Comparable)handler.get(x, o1);
            Comparable c2 = (Comparable)handler.get(x, o2);
            return RelFieldCollation.compare((Comparable)c2, (Comparable)c1, (int)nullComparison);
        };
    }

    private Comparator<RowT> comparator(RelFieldCollation left, RelFieldCollation right) {
        int nullComparison = left.nullDirection.nullComparison;
        if (nullComparison != right.nullDirection.nullComparison) {
            throw new IllegalArgumentException("Can't be compared: left=" + left + ", right=" + right);
        }
        int lIdx = left.getFieldIndex();
        int rIdx = right.getFieldIndex();
        RowHandler handler = this.ctx.rowHandler();
        if (left.direction != right.direction) {
            throw new IllegalArgumentException("Can't be compared: left=" + left + ", right=" + right);
        }
        if (left.direction == RelFieldCollation.Direction.ASCENDING) {
            return (o1, o2) -> {
                Comparable c1 = (Comparable)handler.get(lIdx, o1);
                Comparable c2 = (Comparable)handler.get(rIdx, o2);
                return RelFieldCollation.compare((Comparable)c1, (Comparable)c2, (int)nullComparison);
            };
        }
        return (o1, o2) -> {
            Comparable c1 = (Comparable)handler.get(lIdx, o1);
            Comparable c2 = (Comparable)handler.get(rIdx, o2);
            return RelFieldCollation.compare((Comparable)c2, (Comparable)c1, (int)(-nullComparison));
        };
    }

    @Override
    public Predicate<RowT> predicate(RexNode filter, RelDataType rowType) {
        return new PredicateImpl(this.scalar(filter, rowType));
    }

    @Override
    public BiPredicate<RowT, RowT> biPredicate(RexNode filter, RelDataType rowType) {
        return new BiPredicateImpl(this.biScalar(filter, rowType));
    }

    @Override
    public Function<RowT, RowT> project(List<RexNode> projects, RelDataType rowType) {
        return new ProjectImpl(this.scalar(projects, rowType), this.ctx.rowHandler().factory(this.typeFactory, RexUtil.types(projects)));
    }

    @Override
    public Supplier<RowT> rowSource(List<RexNode> values) {
        return new ValuesImpl(this.scalar(values, null), this.ctx.rowHandler().factory(this.typeFactory, RexUtil.types(values)));
    }

    @Override
    public <T> Supplier<T> execute(RexNode node) {
        return new ValueImpl(this.scalar(node, null), this.ctx.rowHandler().factory(this.typeFactory.getJavaClass(node.getType())));
    }

    @Override
    public Iterable<RowT> values(List<RexLiteral> values, RelDataType rowType) {
        RowHandler<RowT> handler = this.ctx.rowHandler();
        RowHandler.RowFactory<RowT> factory = handler.factory(this.typeFactory, rowType);
        int columns = rowType.getFieldCount();
        assert (values.size() % columns == 0);
        ArrayList types = new ArrayList(columns);
        for (RelDataType type : RelOptUtil.getFieldTypeList((RelDataType)rowType)) {
            types.add(Primitives.wrap((Class)this.typeFactory.getJavaClass(type)));
        }
        ArrayList<RowT> rows = new ArrayList<RowT>(values.size() / columns);
        Object currRow = null;
        for (int i = 0; i < values.size(); ++i) {
            int field = i % columns;
            if (field == 0) {
                RowT RowT = factory.create();
                currRow = RowT;
                rows.add(RowT);
            }
            RexLiteral literal = values.get(i);
            handler.set(field, currRow, literal.getValueAs((Class)types.get(field)));
        }
        return rows;
    }

    private SingleScalar scalar(RexNode node, RelDataType type) {
        return this.scalar(List.of(node), type);
    }

    public SingleScalar scalar(List<RexNode> nodes, RelDataType type) {
        return (SingleScalar)SCALAR_CACHE.computeIfAbsent(this.digest(nodes, type, false), k -> this.compile(nodes, type, false));
    }

    public BiScalar biScalar(RexNode node, RelDataType type) {
        List<RexNode> nodes = List.of(node);
        return (BiScalar)SCALAR_CACHE.computeIfAbsent(this.digest(nodes, type, true), k -> this.compile(nodes, type, true));
    }

    private Scalar compile(Iterable<RexNode> nodes, RelDataType type, boolean biInParams) {
        if (type == null) {
            type = this.emptyType;
        }
        RexProgramBuilder programBuilder = new RexProgramBuilder(type, this.rexBuilder);
        for (RexNode node : nodes) {
            programBuilder.addProject(node, null);
        }
        RexProgram program = programBuilder.getProgram();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression ctx = Expressions.parameter(ExecutionContext.class, (String)"ctx");
        ParameterExpression in1 = Expressions.parameter(Object.class, (String)"in1");
        ParameterExpression in2 = Expressions.parameter(Object.class, (String)"in2");
        ParameterExpression out = Expressions.parameter(Object.class, (String)"out");
        builder.add((Statement)Expressions.declare((int)16, (ParameterExpression)DataContext.ROOT, (Expression)Expressions.convert_((Expression)ctx, DataContext.class)));
        Expression hnd = builder.append("hnd", (Expression)Expressions.call((Expression)ctx, (Method)IgniteMethod.CONTEXT_ROW_HANDLER.method(), (Expression[])new Expression[0]));
        CommonFieldGetter inputGetter = biInParams ? new BiFieldGetter(hnd, (Expression)in1, (Expression)in2, type) : new FieldGetter(hnd, (Expression)in1, type);
        Function1<String, RexToLixTranslator.InputGetter> correlates = new CorrelatesBuilder(builder, (Expression)ctx, hnd).build(nodes);
        List<Expression> projects = RexToLixTranslator.translateProjects(program, (JavaTypeFactory)this.typeFactory, this.conformance, builder, null, (Expression)ctx, inputGetter, correlates);
        for (int i = 0; i < projects.size(); ++i) {
            builder.add(Expressions.statement((Expression)Expressions.call((Expression)hnd, (Method)IgniteMethod.ROW_HANDLER_SET.method(), (Expression[])new Expression[]{Expressions.constant((Object)i), out, projects.get(i)})));
        }
        String methodName = biInParams ? IgniteMethod.BI_SCALAR_EXECUTE.method().getName() : IgniteMethod.SCALAR_EXECUTE.method().getName();
        List<ParameterExpression> params = biInParams ? List.of(ctx, in1, in2, out) : List.of(ctx, in1, out);
        MethodDeclaration decl = Expressions.methodDecl((int)1, Void.TYPE, (String)methodName, params, (BlockStatement)builder.toBlock());
        Class clazz = biInParams ? BiScalar.class : SingleScalar.class;
        return Commons.compile(clazz, Expressions.toString(List.of(decl), (String)"\n", (boolean)false));
    }

    private String digest(List<RexNode> nodes, RelDataType type, boolean biParam) {
        final StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < nodes.size(); ++i) {
            if (i > 0) {
                b.append(';');
            }
            b.append(nodes.get(i));
            new RexShuttle(){

                public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
                    b.append(", fldIdx=").append(fieldAccess.getField().getIndex());
                    return super.visitFieldAccess(fieldAccess);
                }
            }.apply(nodes.get(i));
        }
        b.append(", biParam=").append(biParam);
        b.append(']');
        if (type != null) {
            b.append(':').append(type.getFullTypeString());
        }
        return b.toString();
    }

    private class CorrelatesBuilder
    extends RexShuttle {
        private final BlockBuilder builder;
        private final Expression ctx;
        private final Expression hnd;
        private Map<String, FieldGetter> correlates;

        private CorrelatesBuilder(BlockBuilder builder, Expression ctx, Expression hnd) {
            this.builder = builder;
            this.hnd = hnd;
            this.ctx = ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Function1<String, RexToLixTranslator.InputGetter> build(Iterable<RexNode> nodes) {
            try {
                for (RexNode node : nodes) {
                    node.accept((RexVisitor)this);
                }
                Iterator<RexNode> iterator = this.correlates == null ? null : this.correlates::get;
                return iterator;
            }
            finally {
                this.correlates = null;
            }
        }

        public RexNode visitCorrelVariable(RexCorrelVariable variable) {
            Expression corr = this.builder.append("corr", (Expression)Expressions.call((Expression)this.ctx, (Method)IgniteMethod.CONTEXT_GET_CORRELATED_VALUE.method(), (Expression[])new Expression[]{Expressions.constant((Object)variable.id.getId())}));
            if (this.correlates == null) {
                this.correlates = new HashMap<String, FieldGetter>();
            }
            this.correlates.put(variable.getName(), new FieldGetter(this.hnd, corr, variable.getType()));
            return variable;
        }
    }

    private abstract class CommonFieldGetter
    implements RexToLixTranslator.InputGetter {
        protected final Expression hnd;
        protected final Expression row;
        protected final RelDataType rowType;

        private CommonFieldGetter(Expression hnd, Expression row, RelDataType rowType) {
            this.hnd = hnd;
            this.row = row;
            this.rowType = rowType;
        }

        protected abstract Expression fillExpressions(BlockBuilder var1, int var2);

        @Override
        public Expression field(BlockBuilder list, int index, Type desiredType) {
            Expression fldExpression = this.fillExpressions(list, index);
            Class<Object> fieldType = ExpressionFactoryImpl.this.typeFactory.getJavaClass(((RelDataTypeField)this.rowType.getFieldList().get(index)).getType());
            if (desiredType == null) {
                desiredType = fieldType;
                fieldType = Object.class;
            } else if (fieldType != Date.class && fieldType != Time.class && fieldType != Timestamp.class) {
                fieldType = Object.class;
            }
            return EnumUtils.convert((Expression)fldExpression, (Type)((Object)fieldType), (Type)desiredType);
        }
    }

    private class FieldGetter
    extends CommonFieldGetter {
        private FieldGetter(Expression hnd, Expression row, RelDataType rowType) {
            super(hnd, row, rowType);
        }

        @Override
        protected Expression fillExpressions(BlockBuilder list, int index) {
            Expression row = list.append("row", this.row);
            MethodCallExpression field = Expressions.call((Expression)this.hnd, (Method)IgniteMethod.ROW_HANDLER_GET.method(), (Expression[])new Expression[]{Expressions.constant((Object)index), row});
            return field;
        }
    }

    private class BiFieldGetter
    extends CommonFieldGetter {
        private final Expression row2;

        private BiFieldGetter(Expression hnd, Expression row1, Expression row2, RelDataType rowType) {
            super(hnd, row1, rowType);
            this.row2 = row2;
        }

        @Override
        protected Expression fillExpressions(BlockBuilder list, int index) {
            Expression row1 = list.append("row1", this.row);
            Expression row2 = list.append("row2", this.row2);
            MethodCallExpression field = Expressions.call((Method)IgniteMethod.ROW_HANDLER_BI_GET.method(), (Expression[])new Expression[]{this.hnd, Expressions.constant((Object)index), row1, row2});
            return field;
        }
    }

    private class ValueImpl<T>
    implements Supplier<T> {
        private final SingleScalar scalar;
        private final RowHandler.RowFactory<RowT> factory;

        private ValueImpl(SingleScalar scalar, RowHandler.RowFactory<RowT> factory) {
            this.scalar = scalar;
            this.factory = factory;
        }

        @Override
        public T get() {
            Object res = this.factory.create();
            this.scalar.execute(ExpressionFactoryImpl.this.ctx, null, res);
            return (T)ExpressionFactoryImpl.this.ctx.rowHandler().get(0, res);
        }
    }

    private class ValuesImpl
    implements Supplier<RowT> {
        private final SingleScalar scalar;
        private final RowHandler.RowFactory<RowT> factory;

        private ValuesImpl(SingleScalar scalar, RowHandler.RowFactory<RowT> factory) {
            this.scalar = scalar;
            this.factory = factory;
        }

        @Override
        public RowT get() {
            Object res = this.factory.create();
            this.scalar.execute(ExpressionFactoryImpl.this.ctx, null, res);
            return res;
        }
    }

    private class ProjectImpl
    implements Function<RowT, RowT> {
        private final SingleScalar scalar;
        private final RowHandler.RowFactory<RowT> factory;

        private ProjectImpl(SingleScalar scalar, RowHandler.RowFactory<RowT> factory) {
            this.scalar = scalar;
            this.factory = factory;
        }

        @Override
        public RowT apply(RowT r) {
            Object res = this.factory.create();
            this.scalar.execute(ExpressionFactoryImpl.this.ctx, r, res);
            return res;
        }
    }

    private class BiPredicateImpl
    extends AbstractScalarPredicate<BiScalar>
    implements BiPredicate<RowT, RowT> {
        private BiPredicateImpl(BiScalar scalar) {
            super(ExpressionFactoryImpl.this, (Scalar)scalar);
        }

        @Override
        public boolean test(RowT r1, RowT r2) {
            ((BiScalar)this.scalar).execute(ExpressionFactoryImpl.this.ctx, r1, r2, this.out);
            return Boolean.TRUE == this.hnd.get(0, this.out);
        }
    }

    private class PredicateImpl
    extends AbstractScalarPredicate<SingleScalar>
    implements Predicate<RowT> {
        private PredicateImpl(SingleScalar scalar) {
            super(ExpressionFactoryImpl.this, (Scalar)scalar);
        }

        @Override
        public boolean test(RowT r) {
            ((SingleScalar)this.scalar).execute(ExpressionFactoryImpl.this.ctx, r, this.out);
            return Boolean.TRUE == this.hnd.get(0, this.out);
        }
    }

    private static abstract class AbstractScalarPredicate<T extends Scalar> {
        protected final T scalar;
        protected final RowT out;
        protected final RowHandler<RowT> hnd;
        final /* synthetic */ ExpressionFactoryImpl this$0;

        private AbstractScalarPredicate(T scalar) {
            this.this$0 = var1_1;
            this.scalar = scalar;
            this.hnd = var1_1.ctx.rowHandler();
            this.out = this.hnd.factory(var1_1.typeFactory, var1_1.typeFactory.createJavaType(Boolean.class)).create();
        }
    }
}

