/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.calcite.DataContext;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeSystem;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSqlFunctions {
    private IgniteSqlFunctions() {
    }

    public static ScannableTable systemRange(Object rangeStart, Object rangeEnd) {
        return new RangeTable(rangeStart, rangeEnd, 1L);
    }

    public static ScannableTable systemRange(Object rangeStart, Object rangeEnd, Object increment) {
        return new RangeTable(rangeStart, rangeEnd, increment);
    }

    public static String toString(BigDecimal x) {
        return x == null ? null : x.toPlainString();
    }

    private static BigDecimal setScale(int precision, int scale, BigDecimal decimal) {
        return precision == IgniteTypeSystem.INSTANCE.getDefaultPrecision(SqlTypeName.DECIMAL) ? decimal : decimal.setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal toBigDecimal(double val, int precision, int scale) {
        BigDecimal decimal = BigDecimal.valueOf(val);
        return IgniteSqlFunctions.setScale(precision, scale, decimal);
    }

    public static BigDecimal toBigDecimal(float val, int precision, int scale) {
        BigDecimal decimal = new BigDecimal(String.valueOf(val));
        return IgniteSqlFunctions.setScale(precision, scale, decimal);
    }

    public static BigDecimal toBigDecimal(long val, int precision, int scale) {
        BigDecimal decimal = BigDecimal.valueOf(val);
        return IgniteSqlFunctions.setScale(precision, scale, decimal);
    }

    public static BigDecimal toBigDecimal(int val, int precision, int scale) {
        BigDecimal decimal = new BigDecimal(val);
        return IgniteSqlFunctions.setScale(precision, scale, decimal);
    }

    public static BigDecimal toBigDecimal(short val, int precision, int scale) {
        BigDecimal decimal = new BigDecimal(String.valueOf(val));
        return IgniteSqlFunctions.setScale(precision, scale, decimal);
    }

    public static BigDecimal toBigDecimal(byte val, int precision, int scale) {
        BigDecimal decimal = new BigDecimal(String.valueOf(val));
        return IgniteSqlFunctions.setScale(precision, scale, decimal);
    }

    public static BigDecimal toBigDecimal(boolean val, int precision, int scale) {
        throw new UnsupportedOperationException();
    }

    public static BigDecimal toBigDecimal(String s, int precision, int scale) {
        if (s == null) {
            return null;
        }
        BigDecimal decimal = new BigDecimal(s.trim());
        return IgniteSqlFunctions.setScale(precision, scale, decimal);
    }

    public static BigDecimal toBigDecimal(Number num, int precision, int scale) {
        if (num == null) {
            return null;
        }
        BigDecimal decimal = num instanceof BigDecimal ? (BigDecimal)num : (num instanceof BigInteger ? new BigDecimal((BigInteger)num) : (num instanceof Long ? new BigDecimal(num.longValue()) : BigDecimal.valueOf(num.doubleValue())));
        return IgniteSqlFunctions.setScale(precision, scale, decimal);
    }

    public static BigDecimal toBigDecimal(Object o, int precision, int scale) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            throw new UnsupportedOperationException();
        }
        return o instanceof Number ? IgniteSqlFunctions.toBigDecimal((Number)o, precision, scale) : IgniteSqlFunctions.toBigDecimal(o.toString(), precision, scale);
    }

    private static class RangeTable
    implements ScannableTable {
        private final Object rangeStart;
        private final Object rangeEnd;
        private final Object increment;

        RangeTable(Object rangeStart, Object rangeEnd, Object increment) {
            this.rangeStart = rangeStart;
            this.rangeEnd = rangeEnd;
            this.increment = increment;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("X", SqlTypeName.BIGINT).build();
        }

        public Enumerable<@Nullable Object[]> scan(DataContext root) {
            if (this.rangeStart == null || this.rangeEnd == null || this.increment == null) {
                return Linq4j.emptyEnumerable();
            }
            final long rangeStart = this.convertToLongArg(this.rangeStart, "rangeStart");
            final long rangeEnd = this.convertToLongArg(this.rangeEnd, "rangeEnd");
            final long increment = this.convertToLongArg(this.increment, "increment");
            if (increment == 0L) {
                throw new IllegalArgumentException("Increment can't be 0");
            }
            return new AbstractEnumerable<Object[]>(){

                public Enumerator<@Nullable Object[]> enumerator() {
                    return new Enumerator<Object[]>(){
                        long cur;
                        {
                            this.cur = rangeStart - increment;
                        }

                        public Object[] current() {
                            return new Object[]{this.cur};
                        }

                        public boolean moveNext() {
                            this.cur += increment;
                            return increment > 0L ? this.cur <= rangeEnd : this.cur >= rangeEnd;
                        }

                        public void reset() {
                            this.cur = rangeStart - increment;
                        }

                        public void close() {
                        }
                    };
                }
            };
        }

        private long convertToLongArg(Object val, String name) {
            if (val instanceof Byte || val instanceof Short || val instanceof Integer || val instanceof Long) {
                return ((Number)val).longValue();
            }
            throw new IllegalArgumentException("Unsupported argument type [arg=" + name + ", type=" + val.getClass().getSimpleName() + "]");
        }

        public Statistic getStatistic() {
            throw new UnsupportedOperationException();
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.TABLE;
        }

        public boolean isRolledUp(String column) {
            return false;
        }

        public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig cfg) {
            return true;
        }
    }
}

