/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.sql.engine.schema.InternalIgniteTable;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Tuple;

public class ModifyNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT> {
    private final InternalIgniteTable table;
    private final TableModify.Operation op;
    private final List<String> cols;
    private final RecordView<Tuple> tableView;
    private List<Tuple> tuples = new ArrayList<Tuple>(100);
    private long updatedRows;
    private int waiting;
    private int requested;
    private boolean inLoop;
    private State state = State.UPDATING;

    public ModifyNode(ExecutionContext<RowT> ctx, RelDataType rowType, InternalIgniteTable table, TableModify.Operation op, List<String> cols) {
        super(ctx, rowType);
        this.table = table;
        this.op = op;
        this.cols = cols;
        this.tableView = table.table().recordView();
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0 && this.requested == 0);
        this.checkState();
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.tryEnd();
        }
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        assert (this.state == State.UPDATING);
        this.checkState();
        --this.waiting;
        switch (this.op) {
            case DELETE: 
            case UPDATE: 
            case INSERT: {
                this.tuples.add(this.table.toTuple(this.context(), row, this.op, this.cols));
                this.flushTuples(false);
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.op.name());
            }
        }
        if (this.waiting == 0) {
            this.waiting = 100;
            this.source().request(100);
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        this.waiting = -1;
        this.state = State.UPDATED;
        this.tryEnd();
    }

    @Override
    protected void rewindInternal() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private void tryEnd() throws Exception {
        assert (this.downstream() != null);
        if (this.state == State.UPDATING && this.waiting == 0) {
            this.waiting = 100;
            this.source().request(100);
        }
        if (this.state == State.UPDATED && this.requested > 0) {
            this.flushTuples(true);
            this.state = State.END;
            this.inLoop = true;
            try {
                --this.requested;
                this.downstream().push(this.context().rowHandler().factory(Long.TYPE).create(this.updatedRows));
            }
            finally {
                this.inLoop = false;
            }
        }
        if (this.state == State.END && this.requested > 0) {
            this.requested = 0;
            this.downstream().end();
        }
    }

    private void flushTuples(boolean force) {
        if (CollectionUtils.nullOrEmpty(this.tuples) || !force && this.tuples.size() < 100) {
            return;
        }
        List<Tuple> tuples = this.tuples;
        this.tuples = new ArrayList<Tuple>(100);
        switch (this.op) {
            case INSERT: {
                Collection duplicates = this.tableView.insertAll(null, tuples);
                if (duplicates.isEmpty()) break;
                IgniteTypeFactory typeFactory = this.context().getTypeFactory();
                RowHandler.RowFactory rowFactory = this.context().rowHandler().factory(this.context().getTypeFactory(), this.table.descriptor().insertRowType(typeFactory));
                throw new IgniteInternalException("Failed to INSERT some keys because they are already in cache. [tuples=" + duplicates.stream().map(tup -> this.table.toRow(this.context(), (Tuple)tup, rowFactory, null)).map(this.context().rowHandler()::toString).collect(Collectors.toList()) + "]");
            }
            case UPDATE: {
                this.tableView.upsertAll(null, tuples);
                break;
            }
            case DELETE: {
                this.tableView.deleteAll(null, tuples);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.updatedRows += (long)tuples.size();
    }

    private static enum State {
        UPDATING,
        UPDATED,
        END;

    }
}

