/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.sql.engine.message.ErrorMessage;
import org.apache.ignite.internal.sql.engine.message.ErrorMessageBuilder;

public class ErrorMessageImpl
implements ErrorMessage {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 2;
    private final Throwable error;
    private final long fragmentId;
    private final UUID queryId;

    private ErrorMessageImpl(Throwable error, long fragmentId, UUID queryId) {
        this.error = error;
        this.fragmentId = fragmentId;
        this.queryId = queryId;
    }

    @Override
    public Throwable error() {
        return this.error;
    }

    @Override
    public long fragmentId() {
        return this.fragmentId;
    }

    @Override
    public UUID queryId() {
        return this.queryId;
    }

    public short groupType() {
        return 4;
    }

    public short messageType() {
        return 2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ErrorMessageImpl otherMessage = (ErrorMessageImpl)other;
        return Objects.equals(this.error, otherMessage.error) && Objects.equals(this.queryId, otherMessage.queryId) && this.fragmentId == otherMessage.fragmentId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.fragmentId, this.error, this.queryId);
        return result;
    }

    public static ErrorMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ErrorMessageBuilder {
        private Throwable error;
        private long fragmentId;
        private UUID queryId;

        private Builder() {
        }

        @Override
        public ErrorMessageBuilder error(Throwable error) {
            this.error = error;
            return this;
        }

        @Override
        public ErrorMessageBuilder fragmentId(long fragmentId) {
            this.fragmentId = fragmentId;
            return this;
        }

        @Override
        public ErrorMessageBuilder queryId(UUID queryId) {
            this.queryId = queryId;
            return this;
        }

        @Override
        public Throwable error() {
            return this.error;
        }

        @Override
        public long fragmentId() {
            return this.fragmentId;
        }

        @Override
        public UUID queryId() {
            return this.queryId;
        }

        @Override
        public ErrorMessage build() {
            return new ErrorMessageImpl(this.error, this.fragmentId, this.queryId);
        }
    }
}

