/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.sql.engine.message.OutboxCloseMessage;
import org.apache.ignite.internal.sql.engine.message.OutboxCloseMessageBuilder;

public class OutboxCloseMessageImpl
implements OutboxCloseMessage {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 6;
    private final long exchangeId;
    private final long fragmentId;
    private final UUID queryId;

    private OutboxCloseMessageImpl(long exchangeId, long fragmentId, UUID queryId) {
        this.exchangeId = exchangeId;
        this.fragmentId = fragmentId;
        this.queryId = queryId;
    }

    @Override
    public long exchangeId() {
        return this.exchangeId;
    }

    @Override
    public long fragmentId() {
        return this.fragmentId;
    }

    @Override
    public UUID queryId() {
        return this.queryId;
    }

    public short groupType() {
        return 4;
    }

    public short messageType() {
        return 6;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        OutboxCloseMessageImpl otherMessage = (OutboxCloseMessageImpl)other;
        return Objects.equals(this.queryId, otherMessage.queryId) && this.exchangeId == otherMessage.exchangeId && this.fragmentId == otherMessage.fragmentId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.exchangeId, this.fragmentId, this.queryId);
        return result;
    }

    public static OutboxCloseMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements OutboxCloseMessageBuilder {
        private long exchangeId;
        private long fragmentId;
        private UUID queryId;

        private Builder() {
        }

        @Override
        public OutboxCloseMessageBuilder exchangeId(long exchangeId) {
            this.exchangeId = exchangeId;
            return this;
        }

        @Override
        public OutboxCloseMessageBuilder fragmentId(long fragmentId) {
            this.fragmentId = fragmentId;
            return this;
        }

        @Override
        public OutboxCloseMessageBuilder queryId(UUID queryId) {
            this.queryId = queryId;
            return this;
        }

        @Override
        public long exchangeId() {
            return this.exchangeId;
        }

        @Override
        public long fragmentId() {
            return this.fragmentId;
        }

        @Override
        public UUID queryId() {
            return this.queryId;
        }

        @Override
        public OutboxCloseMessage build() {
            return new OutboxCloseMessageImpl(this.exchangeId, this.fragmentId, this.queryId);
        }
    }
}

