/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.sql.engine.message.QueryBatchAcknowledgeMessage;
import org.apache.ignite.internal.sql.engine.message.QueryBatchAcknowledgeMessageBuilder;

public class QueryBatchAcknowledgeMessageImpl
implements QueryBatchAcknowledgeMessage {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 4;
    private final int batchId;
    private final long exchangeId;
    private final long fragmentId;
    private final UUID queryId;

    private QueryBatchAcknowledgeMessageImpl(int batchId, long exchangeId, long fragmentId, UUID queryId) {
        this.batchId = batchId;
        this.exchangeId = exchangeId;
        this.fragmentId = fragmentId;
        this.queryId = queryId;
    }

    @Override
    public int batchId() {
        return this.batchId;
    }

    @Override
    public long exchangeId() {
        return this.exchangeId;
    }

    @Override
    public long fragmentId() {
        return this.fragmentId;
    }

    @Override
    public UUID queryId() {
        return this.queryId;
    }

    public short groupType() {
        return 4;
    }

    public short messageType() {
        return 4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QueryBatchAcknowledgeMessageImpl otherMessage = (QueryBatchAcknowledgeMessageImpl)other;
        return Objects.equals(this.queryId, otherMessage.queryId) && this.batchId == otherMessage.batchId && this.exchangeId == otherMessage.exchangeId && this.fragmentId == otherMessage.fragmentId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.batchId, this.exchangeId, this.fragmentId, this.queryId);
        return result;
    }

    public static QueryBatchAcknowledgeMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements QueryBatchAcknowledgeMessageBuilder {
        private int batchId;
        private long exchangeId;
        private long fragmentId;
        private UUID queryId;

        private Builder() {
        }

        @Override
        public QueryBatchAcknowledgeMessageBuilder batchId(int batchId) {
            this.batchId = batchId;
            return this;
        }

        @Override
        public QueryBatchAcknowledgeMessageBuilder exchangeId(long exchangeId) {
            this.exchangeId = exchangeId;
            return this;
        }

        @Override
        public QueryBatchAcknowledgeMessageBuilder fragmentId(long fragmentId) {
            this.fragmentId = fragmentId;
            return this;
        }

        @Override
        public QueryBatchAcknowledgeMessageBuilder queryId(UUID queryId) {
            this.queryId = queryId;
            return this;
        }

        @Override
        public int batchId() {
            return this.batchId;
        }

        @Override
        public long exchangeId() {
            return this.exchangeId;
        }

        @Override
        public long fragmentId() {
            return this.fragmentId;
        }

        @Override
        public UUID queryId() {
            return this.queryId;
        }

        @Override
        public QueryBatchAcknowledgeMessage build() {
            return new QueryBatchAcknowledgeMessageImpl(this.batchId, this.exchangeId, this.fragmentId, this.queryId);
        }
    }
}

