/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.sql.engine.message.QueryStartRequest;
import org.apache.ignite.internal.sql.engine.message.QueryStartRequestBuilder;
import org.apache.ignite.internal.sql.engine.metadata.FragmentDescription;

public class QueryStartRequestImpl
implements QueryStartRequest {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 0;
    private final FragmentDescription fragmentDescription;
    private final long fragmentId;
    private final Object[] parameters;
    private final UUID queryId;
    private final String root;
    private final String schema;
    private final long topologyVersion;

    private QueryStartRequestImpl(FragmentDescription fragmentDescription, long fragmentId, Object[] parameters, UUID queryId, String root, String schema, long topologyVersion) {
        this.fragmentDescription = fragmentDescription;
        this.fragmentId = fragmentId;
        this.parameters = parameters;
        this.queryId = queryId;
        this.root = root;
        this.schema = schema;
        this.topologyVersion = topologyVersion;
    }

    @Override
    public FragmentDescription fragmentDescription() {
        return this.fragmentDescription;
    }

    @Override
    public long fragmentId() {
        return this.fragmentId;
    }

    @Override
    public Object[] parameters() {
        return this.parameters;
    }

    @Override
    public UUID queryId() {
        return this.queryId;
    }

    @Override
    public String root() {
        return this.root;
    }

    @Override
    public String schema() {
        return this.schema;
    }

    @Override
    public long topologyVersion() {
        return this.topologyVersion;
    }

    public short groupType() {
        return 4;
    }

    public short messageType() {
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QueryStartRequestImpl otherMessage = (QueryStartRequestImpl)other;
        return Objects.equals(this.fragmentDescription, otherMessage.fragmentDescription) && Objects.equals(this.queryId, otherMessage.queryId) && Objects.equals(this.root, otherMessage.root) && Objects.equals(this.schema, otherMessage.schema) && Arrays.equals(this.parameters, otherMessage.parameters) && this.fragmentId == otherMessage.fragmentId && this.topologyVersion == otherMessage.topologyVersion;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.fragmentId, this.topologyVersion, this.fragmentDescription, this.queryId, this.root, this.schema);
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public static QueryStartRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements QueryStartRequestBuilder {
        private FragmentDescription fragmentDescription;
        private long fragmentId;
        private Object[] parameters;
        private UUID queryId;
        private String root;
        private String schema;
        private long topologyVersion;

        private Builder() {
        }

        @Override
        public QueryStartRequestBuilder fragmentDescription(FragmentDescription fragmentDescription) {
            this.fragmentDescription = fragmentDescription;
            return this;
        }

        @Override
        public QueryStartRequestBuilder fragmentId(long fragmentId) {
            this.fragmentId = fragmentId;
            return this;
        }

        @Override
        public QueryStartRequestBuilder parameters(Object[] parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public QueryStartRequestBuilder queryId(UUID queryId) {
            this.queryId = queryId;
            return this;
        }

        @Override
        public QueryStartRequestBuilder root(String root) {
            this.root = root;
            return this;
        }

        @Override
        public QueryStartRequestBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public QueryStartRequestBuilder topologyVersion(long topologyVersion) {
            this.topologyVersion = topologyVersion;
            return this;
        }

        @Override
        public FragmentDescription fragmentDescription() {
            return this.fragmentDescription;
        }

        @Override
        public long fragmentId() {
            return this.fragmentId;
        }

        @Override
        public Object[] parameters() {
            return this.parameters;
        }

        @Override
        public UUID queryId() {
            return this.queryId;
        }

        @Override
        public String root() {
            return this.root;
        }

        @Override
        public String schema() {
            return this.schema;
        }

        @Override
        public long topologyVersion() {
            return this.topologyVersion;
        }

        @Override
        public QueryStartRequest build() {
            return new QueryStartRequestImpl(this.fragmentDescription, this.fragmentId, this.parameters, this.queryId, this.root, this.schema, this.topologyVersion);
        }
    }
}

